% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_plots.R
\name{lineup_qq}
\alias{lineup_qq}
\title{Check distributional assumptions using Q-Q plots and the lineup protocol.}
\usage{
lineup_qq(
  data,
  variable,
  dist = NULL,
  params = NULL,
  color_points = "black",
  color_lines = "brown3",
  alpha_points = 0.5
)
}
\arguments{
\item{data}{a data frame.}

\item{variable}{the name of the variable that should be plotted.}

\item{dist}{the null distribution name. One of: "beta", "cauchy",
"chi-squared", "exponential", "f", "gamma", "geometric", "log-normal",
"lognormal", "logistic", "negative binomial", "normal",
"poisson", "t", "uniform", "weibull"}

\item{params}{list of parameters of distribution. If \code{NULL}, will
use \code{\link[MASS]{fitdistr}} to estimate them if possible. For
uniform and beta distributions, the parameters must be specified.
See \code{?dunif} and \code{?dbeta} for parameter names.}

\item{color_points}{the color used for points. Can be a name
or a color HEX code.}

\item{color_lines}{the color used for reference lines.}

\item{alpha_points}{the alpha (opacity) used for points (between
0 and 1, where 1 is opaque).}
}
\value{
a \code{ggplot}
}
\description{
This function is used to quickly create lineup plots to check
distributional assumptions using Q-Q plots. The null hypothesis is that the
data follows the distribution specified by the \code{dist} argument.
In the lineup protocol the plot of the real data is embedded amongst a field of
plots of data generated to be consistent with some null hypothesis.
If the observer can pick the real data as different from the others, this
lends weight to the statistical significance of the structure in the plot.
The protocol is described in Buja et al. (2009).
}
\details{
19 null datasets are plotted together the the true data (randomly
positioned)  If you pick the real data as being noticeably different, then
you have formally established that it is different to with p-value 0.05.

Run the \code{decrypt} message printed in the R Console to see which
plot represents the true data.
}
\examples{
data(tips)
lineup_qq(tips, "total_bill", dist = "normal") # Normal distribution
lineup_qq(tips, "total_bill", dist = "gamma") # Gamma distribution

# Some distributions require that the parameters be specified:
tips$proportion_tips <- tips$tip/(tips$total_bill+tips$tip)
lineup_qq(tips, "size", dist = "beta", params = list(shape1 = 0.1, shape2 = 0.2))

# Style the plot using color settings and ggplot2 functions:
lineup_qq(tips, "total_bill",
          dist = "gamma",
          color_points = "chocolate",
          color_lines = "cyan",
          alpha_points = 0.25) +
    ggplot2::theme_minimal()
}
\references{
Buja, Cook, Hofmann, Lawrence, Lee, Swayne, Wickham. (2009).
Statistical inference for exploratory data analysis and model diagnostics,
\emph{Phil. Trans. R. Soc. A}, 367, 4361-4383.
}
\seealso{
null_dist
}
