% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.pf.R
\name{mean.pf}
\alias{mean.pf}
\title{Mean method for objects of class pf}
\usage{
\method{mean}{pf}(x, by_locus = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{pf}: output of \link{pr_total_number_of_distinct_alleles}}

\item{by_locus}{If \code{TRUE} then the results will be returned locus by locus}

\item{...}{other arguments that may p}
}
\value{
either a vector of means, one for each locus, or the sum of the locus means.
The means are the expected number of alleles observed at each locus
}
\description{
Mean method for objects of class pf
}
\examples{
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc.csv",
                           package = "numberofalleles"))
p <- pr_total_number_of_distinct_alleles(contributors = c("U1","U2"),
                                         freqs = freqs)
mean(p)
var(p)
}
