% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNPJ.R, R/CPF.R, R/RENAVAN.R, R/numbersBR.R
\name{==.CNPJ}
\alias{==.CNPJ}
\alias{!=.CNPJ}
\alias{==.CPF}
\alias{!=.CPF}
\alias{==.RENAVAN}
\alias{!=.RENAVAN}
\alias{comparison-methods}
\title{Compare numbers among themselves, with numeric and character objects.}
\usage{
\method{==}{CNPJ}(e1, e2)

\method{!=}{CNPJ}(e1, e2)

\method{==}{CPF}(e1, e2)

\method{!=}{CPF}(e1, e2)

\method{==}{RENAVAN}(e1, e2)

\method{!=}{RENAVAN}(e1, e2)
}
\arguments{
\item{e1}{the identification number class.}

\item{e2}{the object to be compared with, can be of the same type of \code{e1}, a numeric or character vector}
}
\value{
A logical vector indicating that the given objects represent the same number.
}
\description{
Compares the brazilian numbers among themselves, with numeric and character objects.
}
\examples{
x <- CNPJ(13515463000138)
x == '13515463000138'
x <- CPF(68194359406)
x != "681.943.594-06"
x <- RENAVAN(68194359406)
x == "68194359406"
}
