##
##  p r o g r e s s s i o n . R
##


arithmetic_progression <- function(a, d, n) {
    stopifnot(is.numeric(a), is.numeric(d), is.numeric(n))
    b <- a + (n-1)*d
    s <- seq(a, b, by = d)
    return(s)
}

# The arithmetic progression from a to b with difference d 
# will be generated with
#     n = floor((b-a)/d)+1
#     s = arithmetic_progression(a, d, n)
#       = seq(a, n*d, by = d)
#

# Sum of squares of reciprocals of an arithmetic progression:
#     a = 7; d = 11; n = 1000
#     sum(1/arithmetic_progression(a, d, n)^2)  # 0.0272888
#     # = trigamma(a/d)/d^2                     # 0.0272971
#
