% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{applyMagneticDeclination,adp-method}
\alias{applyMagneticDeclination,adp-method}
\title{Alter an adp Object to Account for Magnetic Declination}
\usage{
\S4method{applyMagneticDeclination}{adp}(
  object = "oce",
  declination = 0,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{an \linkS4class{adp} object.}

\item{declination}{numeric value holding magnetic declination in degrees,
positive for clockwise from north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
An \linkS4class{adp} object, modified as outlined  in \dQuote{Description}.
}
\description{
Acoustic-Doppler profiling instruments that infer direction using magnetic
compasses to determine current direction need to have a correction applied
for magnetic declination, if the goal is to infer currents with x and y
oriented eastward and northward, respectively.  This is what the present
function does (see \dQuote{Details}).
}
\details{
The returned value is a copy of \code{object} that has been modified in 4 ways.
(1) the horizontal components of velocity are rotated clockwise by
\code{declination} degrees.  (2) If the object holds heading values, then
\code{declination} is added to them. (3) The \code{north} item in the \code{metadata} slot
is set to \code{"geographic"}, and a warning is issued if this was also the value
in \code{object}.  (4) The \code{declination} item in the \code{metadata} slot is set to
the value supplied to this function.
}
\examples{
# Transform beam coordinate to xyx, then to enu with respect to
# magnetic north, and then to geographic north.
library(oce)
file <- system.file("extdata", "adp_rdi.000", package = "oce")
lon <- -69.73433
lat <- 47.88126
beam <- read.oce(file, from = 1, to = 4, longitude = lon, latitude = lat)
dec <- magneticField(lon, lat, beam[["time"]][1])$declination
xyz <- beamToXyzAdp(beam)
# Here, we tell xyzToEnuAdp() not to set a declination,
# so enuMag has metadata$north equal to "magnetic".  We could
# also skip the use of applyMagneticDeclination() by supplying
# the known declination to xyzToEnuAdp().
enuMag <- xyzToEnuAdp(xyz, declination = NULL)
enuGeo <- applyMagneticDeclination(enuMag, declination = dec)

}
\seealso{
Use \code{\link[=magneticField]{magneticField()}} to determine the declination,
inclination and intensity at a given spot on the world, at a given time.

Other things related to magnetism: 
\code{\link{applyMagneticDeclination}()},
\code{\link{applyMagneticDeclination,adv-method}},
\code{\link{applyMagneticDeclination,cm-method}},
\code{\link{applyMagneticDeclination,oce-method}},
\code{\link{magneticField}()}

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp}},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdp}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp}()},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.aquadopp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdp}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnuAdpAD2CP}()}
}
\author{
Dan Kelley, aided by Clark Richards and Jaimie Harbin.
}
\concept{things related to adp data}
\concept{things related to magnetism}
