% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tree_info}
\alias{tree_info}
\title{Tree Information in Readable Format}
\usage{
tree_info(object, tree = 1)
}
\arguments{
\item{object}{\code{ocf.forest} object.}

\item{tree}{Number of the tree of interest.}
}
\value{
A \code{data.frame} with the following columns:
   \item{\code{nodeID}}{Node IDs.} 
   \item{\code{leftChild}}{IDs of the left child node.} 
   \item{\code{rightChild}}{IDs of the right child node.} 
   \item{\code{splitvarID}}{IDs of the splitting variable.}
   \item{\code{splitvarName}}{Name of the splitting variable.}
   \item{\code{splitval}}{Splitting value.} 
   \item{\code{terminal}}{Logical, TRUE for terminal nodes.} 
   \item{\code{prediction}}{One column with the predicted conditional class probabilities.}
}
\description{
Extracts tree information from a \code{ocf.forest} object.
}
\details{
Nodes and variables IDs are 0-indexed, i.e., node 0 is the root node. \cr

All values smaller than or equal to \code{splitval} go to the left and all values larger go to the right.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_ordered_data(1000)
sample <- data$sample
Y <- sample$Y
X <- sample[, -1]

## Fit ocf.
forests <- ocf(Y, X)

## Extract information from tenth tree of first forest.
info <- tree_info(forests$forests.info$forest.1, tree = 10)
head(info)}
  
}
\references{
\itemize{
  \item Di Francesco, R. (2025). Ordered Correlation Forest. Econometric Reviews, 1–17. \doi{10.1080/07474938.2024.2429596}.
}
}
\seealso{
\code{\link{ocf}}
}
\author{
Riccardo Di Francesco
}
