% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gam.R
\name{plot_gam}
\alias{plot_gam}
\title{Plot GAM(M) Smoothing Function}
\usage{
plot_gam(
  model = NULL,
  pred = NULL,
  col_line = "blue",
  ci_line_col = "black",
  ci_line_type = "dashed",
  ci_fill = "grey",
  ci_alpha = 0.4,
  ci_line_size = 0.8,
  sm_fun_size = 1.1,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  limits_y = NULL,
  breaks_y = NULL
)
}
\arguments{
\item{model}{A fitted model of class \code{gam}.}

\item{pred}{Predictor name.}

\item{col_line}{Smoothing function line color.}

\item{ci_line_col}{Confident interval line color.}

\item{ci_line_type}{Linetype of confidence interval.}

\item{ci_fill}{Fill color of area between smoothing function and its
confidence interval lines.}

\item{ci_alpha}{Opacity value of confidence interval.}

\item{ci_line_size, sm_fun_size}{Line sizes.}

\item{title}{Plot title.}

\item{xlab}{x-axis title.}

\item{ylab}{y-axis title.}

\item{limits_y}{y-axis limits.}

\item{breaks_y}{y-axis breaks. Values are handed over to a \code{seq} call, e.g.
\code{seq(-6, 6, 2)}.}
}
\description{
Plots the smoothing function of GAM(M) predictors via ggplot2
}
\examples{
library(oddsratio)
library(mgcv)
fit_gam <- mgcv::gam(y ~ s(x0) + s(I(x1^2)) + s(x2) + offset(x3) + x4,
  data = data_gam
)

plot_gam(fit_gam, pred = "x2", title = "Predictor 'x2'")
}
\seealso{
\code{\link[=or_gam]{or_gam()}} \code{\link[=insert_or]{insert_or()}}
}
