% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect.R
\name{expect_images_match}
\alias{expect_images_match}
\alias{expect_images_differ}
\title{testthat Expectations for Image Comparison}
\usage{
expect_images_match(
  actual,
  expected,
  threshold = 0.1,
  antialiasing = FALSE,
  fail_on_layout = TRUE,
  ignore_regions = NULL,
  ...,
  info = NULL,
  label = NULL
)

expect_images_differ(
  img1,
  img2,
  threshold = 0.1,
  antialiasing = FALSE,
  ...,
  info = NULL,
  label = NULL
)
}
\arguments{
\item{actual}{Path to the actual/current image, or a magick-image object.}

\item{expected}{Path to the expected/baseline image, or a magick-image object.}

\item{threshold}{Numeric; color difference threshold between 0.0 and 1.0.
Default is 0.1.}

\item{antialiasing}{Logical; if \code{TRUE}, ignore antialiased pixels.
Default is \code{FALSE}.}

\item{fail_on_layout}{Logical; if \code{TRUE}, fail if images have different
dimensions. Default is \code{TRUE} for tests (stricter than \code{\link[=compare_images]{compare_images()}}).}

\item{ignore_regions}{List of regions to ignore during comparison.
Use \code{\link[=ignore_region]{ignore_region()}} to create regions, or pass a data.frame with
columns \code{x1}, \code{y1}, \code{x2}, \code{y2}.}

\item{...}{Additional arguments passed to \code{\link[=odiff_run]{odiff_run()}}.}

\item{info}{Extra information to be included in the failure message
(useful for providing context about what was being tested).}

\item{label}{Optional custom label for the actual image in failure messages.
If not provided, uses the deparsed expression.}

\item{img1, img2}{Paths to images being compared (for \code{expect_images_differ}).}
}
\value{
Invisibly returns the comparison result (a data.frame/tibble with
match, reason, diff_count, diff_percentage, etc.), allowing further
inspection if needed.
}
\description{
Assert that images match or differ using odiff. These expectations are
designed for visual regression testing in testthat test suites.
}
\details{
\code{expect_images_match()} asserts that two images are visually identical
(within the specified threshold). On failure, a diff image is saved to
\verb{tests/testthat/_odiffr/} by default, which can be controlled via
\code{options(odiffr.save_diff = FALSE)} or \code{options(odiffr.diff_dir = "path")}.

\code{expect_images_differ()} asserts that two images are visually different.
No diff image is saved since there's nothing to debug when images match
unexpectedly.

Both expectations will skip (not fail) if the odiff binary is not available,
making tests portable across environments.
}
\section{Comparison with vdiffr}{

odiffr expectations are designed for \strong{pixel-based} comparison of
screenshots, rendered images, and bitmap files. For \strong{SVG-based} comparison
of ggplot2 and grid graphics, consider using the vdiffr package instead.
The two approaches are complementary.
}

\examples{
\dontrun{
# Basic visual regression test
test_that("login page renders correctly", {
  skip_if_no_odiff()

  expect_images_match(
    "screenshots/login_current.png",
    "screenshots/login_baseline.png"
  )
})

# With tolerance for minor differences
test_that("chart renders correctly", {
  skip_if_no_odiff()

  expect_images_match(
    "actual_chart.png",
    "expected_chart.png",
    threshold = 0.2,
    antialiasing = TRUE,
    ignore_regions = list(
      ignore_region(0, 0, 100, 30)  # Ignore timestamp
    )
  )
})

# Assert images are different
test_that("button changes on hover", {
  skip_if_no_odiff()

  expect_images_differ(
    "button_normal.png",
    "button_hover.png"
  )
})
}
}
\seealso{
\code{\link[=compare_images]{compare_images()}} for the underlying comparison function,
\code{\link[=ignore_region]{ignore_region()}} for excluding regions from comparison.
}
