% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_change_point.R
\name{RangeToPoint}
\alias{RangeToPoint}
\title{Get Change Points from Peak Ranges}
\usage{
RangeToPoint(y, n_peak_range, peak_range, get_loglik = GetLogLik)
}
\arguments{
\item{y}{The original data to find change points. Must be one dimensional data.}

\item{n_peak_range}{The number of peak ranges of change points}

\item{peak_range}{The location of ranges of change points}

\item{get_loglik}{The method to get}
}
\value{
change_point
}
\description{
Transform the peak ranges of change points to exact change points.
}
\details{
Find the exact change points with peak ranges based on log likelihood comparison.
}
\examples{
N <- 1000
N1 <- floor(0.1*N)
N2 <- floor(0.3*N)
a1 <- c(0.8, -0.3); c1 <- 0
a2 <- c(-0.5, 0.1); c2 <- 0
a3 <- c(0.5, -0.5); c3 <- 0
y <- rep(0,N)
L<-2
y[1:L] <- rnorm(L)
for (n in (L+1):N){
  if (n <= N1) {
    y[n] <- y[(n-1):(n-L)] \%*\% a1 + c1 + rnorm(1)
  } else if (n <= (N1+N2)) {
    y[n] <- y[(n-1):(n-L)] \%*\% a2 + c2 + rnorm(1)
  }
  else {
    y[n] <- y[(n-1):(n-L)] \%*\% a3 + c3 + rnorm(1)
  }
}
RangeToPoint(y,n_peak_range=2,peak_range=list(seq(70,105),seq(395,420)))
}
