% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restAPI.R
\name{restAPI}
\alias{restAPI}
\title{restAPI Class}
\description{
Base class for \href{https://www.okx.com/docs-v5/en/}{Okx exchange v5 API}.
}
\details{
You can implement all REST API requests in Okx exchange by inheriting the \code{restAPI} class.
Please refer to the example provided at the end of the document.

For commonly used interfaces, they have been implemented in this package.
The naming convention is as follows: for "/api/v5/AAA/BBB", a new class named \code{restAPIAAA},
which inherits from \code{restAPI}, has been defined in this package.
The \code{BBB} method in this new class is used to call the API.
}
\examples{
\dontrun{
# for [Get currencies](https://www.okx.com/docs-v5/en/#rest-api-funding-get-currencies)
# you can define the class like this
myRestAPI <- R6::R6Class(
  inherit = restAPI,
  public = list(
    get_currencies = function(ccy, process = "identity") {
      self$get_result(
        api = "/api/v5/asset/currencies", method = "GET", process = process,
        ccy = ccy
      )
    }
  )
)
# And call it like this
tmp <- myRestAPI$new(api_key, secret_key, passphrase)
tmp$get_currencies("BTC")
}

}
\seealso{
\code{\link{restAPItrade}}
\code{\link{restAPIaccount}}
\code{\link{restAPImarket}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{url}}{Okx REST API url, which is https://www.okx.com.}

\item{\code{api_key}}{Okx API key.}

\item{\code{secret_key}}{Okx API secret key.}

\item{\code{passphrase}}{Okx API passphrase.}

\item{\code{simulate}}{Whether to use demo trading service.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-restAPI-new}{\code{restAPI$new()}}
\item \href{#method-restAPI-get_timestamp}{\code{restAPI$get_timestamp()}}
\item \href{#method-restAPI-get_request_path}{\code{restAPI$get_request_path()}}
\item \href{#method-restAPI-get_body}{\code{restAPI$get_body()}}
\item \href{#method-restAPI-get_message}{\code{restAPI$get_message()}}
\item \href{#method-restAPI-get_signature}{\code{restAPI$get_signature()}}
\item \href{#method-restAPI-get_header}{\code{restAPI$get_header()}}
\item \href{#method-restAPI-get_result}{\code{restAPI$get_result()}}
\item \href{#method-restAPI-clone}{\code{restAPI$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-new"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-new}{}}}
\subsection{Method \code{new()}}{
Create a new REST API object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$new(api_key, secret_key, passphrase, simulate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{Okx API key.}

\item{\code{secret_key}}{Okx API secret key.}

\item{\code{passphrase}}{Okx API passphrase.}

\item{\code{simulate}}{Whether to use demo trading service.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_timestamp"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_timestamp}{}}}
\subsection{Method \code{get_timestamp()}}{
Get UTC timestamp.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_timestamp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_request_path"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_request_path}{}}}
\subsection{Method \code{get_request_path()}}{
Get request path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_request_path(api, method = c("GET", "POST"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api}}{Request api e.g. /api/v5/account/positions-history.}

\item{\code{method}}{Request method, \code{GET} or \code{POST}.}

\item{\code{...}}{Other request parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_body"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_body}{}}}
\subsection{Method \code{get_body()}}{
Get request body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_body(method = c("GET", "POST"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Request method, \code{GET} or \code{POST}.}

\item{\code{...}}{Other request parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_message"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_message}{}}}
\subsection{Method \code{get_message()}}{
Get the signing messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_message(timestamp, request_path, body, method = c("GET", "POST"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timestamp}}{Retrieve through method \code{get_timestamp}.}

\item{\code{request_path}}{Retrieve through method \code{get_request_path}.}

\item{\code{body}}{Retrieve through method \code{get_body}.}

\item{\code{method}}{Request method, \code{GET} or \code{POST}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_signature"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_signature}{}}}
\subsection{Method \code{get_signature()}}{
Get the signature.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_signature(msg, secret_key = self$secret_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Retrieve through method \code{get_message}.}

\item{\code{secret_key}}{Okx API secret key.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_header"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_header}{}}}
\subsection{Method \code{get_header()}}{
Get request headers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_header(timestamp, msg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timestamp}}{Retrieve through method \code{get_timestamp}.}

\item{\code{msg}}{Retrieve through method \code{get_message}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-get_result"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-get_result}{}}}
\subsection{Method \code{get_result()}}{
Retrieve data from api.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$get_result(api, method = c("GET", "POST"), process, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api}}{Request api e.g. /api/v5/account/positions-history.}

\item{\code{method}}{Request method, \code{GET} or \code{POST}.}

\item{\code{process}}{A function to process the data received from the API.}

\item{\code{...}}{Other request parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restAPI-clone"></a>}}
\if{latex}{\out{\hypertarget{method-restAPI-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{restAPI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
