% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-oldr.R
\docType{package}
\name{oldr}
\alias{oldr-package}
\alias{oldr}
\title{An Implementation of Rapid Assessment Method for Older People (RAM-OP)}
\description{
\href{https://www.helpage.org/}{HelpAge International}, VALID International, and
\href{http://www.brixtonhealth.com}{Brixton Health}, with financial
assistance from the
\href{http://www.elrha.org/hif/home/}{Humanitarian Innovation Fund (HIF)}, have
developed a \strong{Rapid Assessment Method for Older People (RAM-OP)} that
provides accurate and reliable estimates of the needs of older people. The
method uses simple procedures, in a short time frame (i.e. about two weeks
including training, data collection, data entry, and data analysis), and at
considerably lower cost than other methods.
}
\details{
The \strong{RAM-OP} method is based on the following principles:
\itemize{
\item Use of a familiar \emph{“household survey”} design employing a two-stage cluster
sample design optimised to allow the use of a small primary sample
(\code{m >= 16} clusters) and a small overall (\code{n = 192}) sample.
\item Assessment of multiple dimensions of need in older people (including
prevalence of global, moderate and severe acute malnutrition) using,
whenever possible, standard and well-tested indicators and question sets.
\item Data analysis performed using modern computer-intensive methods to allow
estimates of indicator levels to be made with useful precision using a small
sample size.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rapidsurveys.io/oldr/}
  \item \url{https://github.com/rapidsurveys/oldr}
  \item Report bugs at \url{https://github.com/rapidsurveys/oldr/issues}
}

}
\author{
\strong{Maintainer}: Ernest Guevarra \email{ernest@guevarra.io} (\href{https://orcid.org/0000-0002-4887-4415}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Mark Myatt \email{mark@brixtonhealth.com} (\href{https://orcid.org/0000-0003-1119-1474}{ORCID}) [copyright holder]
  \item Pascale Fritsch
  \item Katja Siling
}

Other contributors:
\itemize{
  \item HelpAge International [copyright holder]
  \item Elrha [funder]
}

}
\keyword{internal}
