% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_normalize.R
\name{check_match}
\alias{check_match}
\title{Check Match}
\usage{
check_match(area_data, istd_area_data)
}
\arguments{
\item{area_data}{A data frame containing the area data.}

\item{istd_area_data}{A data frame containing the internal standard area data.}
}
\value{
A logical value indicating if the sample IDs and column names match.
}
\description{
This function checks if sample IDs and column names match between area data and internal standard area data.
}
\examples{
area_data <- data.frame(sample_id = c("S1", "S2", "S3"), A = 1:3, B = 4:6)
istd_area_data <- data.frame(sample_id = c("S1", "S2", "S3"), A = 1:3, B = 4:6)
check_match(area_data, istd_area_data)
}
