% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{additionalColumns}
\alias{additionalColumns}
\title{Identify variables in additional_name column}
\usage{
additionalColumns(result)
}
\arguments{
\item{result}{A tibble.}
}
\value{
Unique values of the additional name column.
}
\description{
Identifies and returns the unique values in additional_name
column.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> additionalColumns()
}

}
