% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitByDate.R
\name{splitByDate}
\alias{splitByDate}
\title{Divide up a data frame by time}
\usage{
splitByDate(
  mydata,
  dates = "1/1/2003",
  labels = c("before", "after"),
  name = "split.by",
  format = c("\%d/\%m/\%Y", "\%Y/\%m/\%d", "\%d/\%m/\%Y \%H:\%M:\%S",
    "\%Y/\%m/\%d \%H:\%M:\%S")
)
}
\arguments{
\item{mydata}{A data frame containing a \code{date} field in an hourly or high
resolution format.}

\item{dates}{A date or dates to split data by. Can be passed as R date(time)
objects or as characters. If passed as a character, \code{\link[=splitByDate]{splitByDate()}} expects
either "DD/MM/YYYY" or "YYYY/MM/DD" by default, but this can be chaned
using the \code{format} argument.}

\item{labels}{Labels for each time partition. Should always be one more
\code{label} than there are \code{dates}; for example, if \verb{dates = "2020/01/01},
\code{\link[=splitByDate]{splitByDate()}} requires one label for \emph{before} that date and one label for
\emph{after}.}

\item{name}{The name to give the new column to identify the periods split.
Defaults to \code{"split.by"}.}

\item{format}{When \code{dates} are provided as character strings, this option
defines the formats \code{\link[=splitByDate]{splitByDate()}} will use to coerce \code{dates} into R
\code{Date} or \code{POSIXCt} objects. Passed to \code{\link[lubridate:as_date]{lubridate::as_date()}} or
\code{\link[lubridate:as_date]{lubridate::as_datetime()}}. See \code{\link[=strptime]{strptime()}} for more information.}
}
\description{
This function partitions a data frame up into different time segments. It
produces a new column called controlled by \code{name} that can be used in many
\code{openair} functions. Note that there must be one more \code{labels} than there are
\code{dates}.
}
\examples{
# split data up into "before" and "after"
mydata <- splitByDate(mydata,
  dates = "1/04/2000",
  labels = c("before", "after")
)

# split data into 3 partitions
mydata <- splitByDate(mydata,
  dates = c("1/1/2000", "1/3/2003"),
  labels = c("before", "during", "after")
)

# if you have modelled data - could split into modelled and measured by the
# break date
dummy <- data.frame(
  date = Sys.Date() + (-5:5),
  nox = 100 + seq(-50, 50, 10)
)
splitByDate(dummy,
  dates = Sys.Date(),
  labels = c("measured", "modelled"),
  name = "data_type"
)
}
\author{
David Carslaw
}
