% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_diffMap.R
\name{diffMap}
\alias{diffMap}
\title{Bivariate polar 'difference' plots on dynamic and static maps}
\usage{
diffMap(
  before,
  after,
  pollutant = NULL,
  x = "ws",
  limits = "free",
  latitude = NULL,
  longitude = NULL,
  crs = 4326,
  type = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = rev(openair::openColours("RdBu", 10)),
  alpha = 1,
  key = FALSE,
  legend = TRUE,
  legend.position = NULL,
  legend.title = NULL,
  legend.title.autotext = TRUE,
  control.collapsed = FALSE,
  control.position = "topright",
  control.autotext = TRUE,
  d.icon = 200,
  d.fig = 3.5,
  static = FALSE,
  static.nrow = NULL,
  progress = TRUE,
  ...,
  control = NULL
)
}
\arguments{
\item{before}{A data frame that represents the "before" case. See
\code{\link[openair:polarPlot]{polarPlot()}} for details of different input requirements.}

\item{after}{A data frame that represents the "after" case. See \code{\link[openair:polarPlot]{polarPlot()}}
for details of different input requirements.}

\item{pollutant}{Mandatory. A pollutant name corresponding to a variable in a
data frame should be supplied e.g. \code{pollutant = "nox"}. There can also
be more than one pollutant specified e.g. \code{pollutant = c("nox",
  "no2")}. The main use of using two or more pollutants is for model
evaluation where two species would be expected to have similar
concentrations. This saves the user stacking the data and it is possible to
work with columns of data directly. A typical use would be \code{pollutant
  = c("obs", "mod")} to compare two columns \dQuote{obs} (the observations)
and \dQuote{mod} (modelled values). When pair-wise statistics such as
Pearson correlation and regression techniques are to be plotted,
\code{pollutant} takes two elements too. For example, \code{pollutant =
  c("bc", "pm25")} where \code{"bc"} is a function of \code{"pm25"}.}

\item{x}{Name of variable to plot against wind direction in polar
coordinates, the default is wind speed, \dQuote{ws}.}

\item{limits}{\emph{Limits for the plot colour scale.}

\emph{default:} \code{"free"} | \emph{scope:} dynamic & static

One of:
\itemize{
\item \code{"free"} (the default) which allows all of the markers to use different
colour scales.
\item A numeric vector in the form \code{c(lower, upper)} used to define the colour
scale. For example, \code{limits = c(-10, 10)} would force the plot limits to
span -10 to 10. It is recommended to use a symmetrical limit scale (along
with a "diverging" colour palette) for effective visualisation.
}

Note that the \code{"fixed"} option is not supported in \code{\link[=diffMap]{diffMap()}}.}

\item{latitude, longitude}{\emph{The decimal latitude(Y)/longitude(X).}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Column names representing the decimal latitude and longitude (or other Y/X
coordinate if using a different \code{crs}). If not provided, will be
automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{crs}{\emph{The coordinate reference system (CRS).}

\emph{default:} \code{4326} | \emph{scope:} dynamic & static

The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for
plotting on the map.}

\item{type}{\emph{A method to condition the \code{data} for separate plotting.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

Used for splitting the input data into different groups, passed to the
\code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. When \code{type} is specified:
\itemize{
\item \emph{Dynamic}: The different data splits can be toggled between using a "layer control" menu.
\item \emph{Static:}: The data splits will each appear in a different panel.
}

\code{type} cannot be used if multiple \code{pollutant} columns have been provided.}

\item{popup}{\emph{Content for marker popups on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Columns to be used as the HTML content for marker popups on dynamic maps.
Popups may be useful to show information about the individual sites (e.g.,
site names, codes, types, etc.). If a vector of column names are provided
they are passed to \code{\link[=buildPopup]{buildPopup()}} using its default values.}

\item{label}{\emph{Content for marker hover-over on dynamic maps.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic

Column to be used as the HTML content for hover-over labels. Labels are
useful for the same reasons as popups, though are typically shorter.}

\item{provider}{\emph{The basemap(s) to be used.}

\emph{default:} \code{"OpenStreetMap"} | \emph{scope:} dynamic & static

The base map(s) to be used beneath the polar markers. If not provided, will
default to \code{"OpenStreetMap"}/\code{"osm"} for both dynamic and static maps.
\itemize{
\item \emph{Dynamic}: Any number of \link[leaflet:providers]{leaflet::providers}.
See \url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface. By default, the
interface will use the provider names as labels, but users can define their
own using a named vector (e.g., \code{c("Default" = "OpenStreetMap", "Satellite"   = "Esri.WorldImagery")})
\item \emph{Static}: One of \code{\link[rosm:deprecated]{rosm::osm.types()}}.
}

There is some overlap in static and dynamic providers. For example,
\code{{ggspatial}} uses "osm" to specify "OpenStreetMap". When static providers
are provided to dynamic maps or vice versa, \code{{openairmaps}} will attempt to
substitute the correct provider string.}

\item{cols}{\emph{Colours to use for plotting.}

\emph{default:} \code{rev(openair::openColours("RdBu", 10))} | \emph{scope:} dynamic & static

The colours used for plotting, passed to \code{\link[openair:openColours]{openair::openColours()}}.  It is
recommended to use a "diverging" colour palette (along with a symmetrical
\code{limit} scale) for effective visualisation.}

\item{alpha}{\emph{Transparency value for polar markers.}

\emph{default:} \code{1} | \emph{scope:} dynamic & static

A value between 0 (fully transparent) and 1 (fully opaque).}

\item{key}{\emph{Draw individual marker legends?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic & static

Draw a key for each individual marker? Potentially useful when \code{limits = "free"}, but of limited use otherwise.}

\item{legend}{\emph{Draw a shared legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When all markers share the same colour scale (e.g., when \code{limits != "free"}
in \code{\link[=polarMap]{polarMap()}}), should a shared legend be created at the side of the map?}

\item{legend.position}{\emph{Position of the shared legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

When \code{legend = TRUE}, where should the legend be placed?
\itemize{
\item \emph{Dynamic}: One of "topright", "topright", "bottomleft" or "bottomright". Passed to the \code{position} argument of \code{\link[leaflet:addLegend]{leaflet::addLegend()}}.
\item \emph{Static:}: One of "top", "right", "bottom" or "left". Passed to the \code{legend.position} argument of \code{\link[ggplot2:theme]{ggplot2::theme()}}.
}}

\item{legend.title}{\emph{Title of the legend.}

\emph{default:} \code{NULL} | \emph{scope:} dynamic & static

By default, when \code{legend.title = NULL}, the function will attempt to
provide a sensible legend title. \code{legend.title} allows users to overwrite
this - for example, to include units or other contextual information. For
\emph{dynamic} maps, users may wish to use HTML tags to format the title.}

\item{legend.title.autotext}{\emph{Automatically format the title of the legend?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

When \code{legend.title.autotext = TRUE}, \code{legend.title} will be first run
through \code{\link[=quickTextHTML]{quickTextHTML()}} (\emph{dynamic}) or \code{\link[openair:quickText]{openair::quickText()}} (\emph{static}).}

\item{control.collapsed}{\emph{Show the layer control as a collapsed?}

\emph{default:} \code{FALSE} | \emph{scope:} dynamic

For \emph{dynamic} maps, should the "layer control" interface be collapsed? If
\code{TRUE}, users will have to hover over an icon to view the options.}

\item{control.position}{\emph{Position of the layer control menu}

\emph{default:} \code{"topright"} | \emph{scope:} dynamic

When \code{type != NULL}, or multiple pollutants are specified, where should the
"layer control" interface be placed? One of "topleft", "topright",
"bottomleft" or "bottomright". Passed to the \code{position} argument of
\code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}}.}

\item{control.autotext}{\emph{Automatically format the content of the layer
control menu?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic

When \code{control.autotext = TRUE}, the content of the "layer control"
interface will be first run through \code{\link[=quickTextHTML]{quickTextHTML()}}.}

\item{d.icon}{\emph{The diameter of the plot on the map in pixels.}

\emph{default:} \code{200} | \emph{scope:} dynamic & static

This will affect the size of the individual polar markers. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{d.fig}{\emph{The diameter of the plots to be produced using \code{{openair}} in
inches.}

\emph{default:} \code{3.5} | \emph{scope:} dynamic & static

This will affect the resolution of the markers on the map. Alternatively, a
vector in the form \code{c(width, height)} can be provided if a non-circular
marker is desired.}

\item{static}{\emph{Produce a static map?}

\emph{default:} \code{FALSE}

This controls whether a \emph{dynamic} or \emph{static} map is produced. The former
is the default and is broadly more useful, but the latter may be preferable
for DOCX or PDF outputs (e.g., academic papers).}

\item{static.nrow}{\emph{Number of rows in a static map.}

\emph{default:} \code{NULL} | \emph{scope:} static

Controls the number of rows of panels on a static map when multiple
\code{pollutant}s or \code{type} are specified; passed to the \code{nrow} argument of
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}. The default, \code{NULL}, results in a roughly square
grid of panels.}

\item{progress}{\emph{Show a progress bar?}

\emph{default:} \code{TRUE} | \emph{scope:} dynamic & static

By default, a progress bar is shown to visualise the function's progress
creating individual polar markers. This option allows this to be turned
off, if desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:polarPlot]{openair::polarPlot}}
  \describe{
    \item{\code{wd}}{Name of wind direction field.}
    \item{\code{statistic}}{The statistic that should be applied to each wind
speed/direction bin. Because of the smoothing involved, the colour scale
for some of these statistics is only to provide an indication of overall
pattern and should not be interpreted in concentration units e.g. for
\code{statistic = "weighted.mean"} where the bin mean is multiplied by the
bin frequency and divided by the total frequency. In many cases using
\code{polarFreq} will be better. Setting \code{statistic = "weighted.mean"}
can be useful because it provides an indication of the concentration *
frequency of occurrence and will highlight the wind speed/direction
conditions that dominate the overall mean.Can be:

\itemize{ \item  \dQuote{mean} (default), \dQuote{median}, \dQuote{max}
(maximum), \dQuote{frequency}. \dQuote{stdev} (standard deviation),
\dQuote{weighted.mean}.

\item \code{statistic = "nwr"} Implements the Non-parametric Wind
Regression approach of Henry et al. (2009) that uses kernel smoothers. The
\code{openair} implementation is not identical because Gaussian kernels are
used for both wind direction and speed. The smoothing is controlled by
\code{ws_spread} and \code{wd_spread}.

\item \code{statistic = "cpf"} the conditional probability function (CPF)
is plotted and a single (usually high) percentile level is supplied. The
CPF is defined as CPF = my/ny, where my is the number of samples in the y
bin (by default a wind direction, wind speed interval) with mixing ratios
greater than the \emph{overall} percentile concentration, and ny is the
total number of samples in the same wind sector (see Ashbaugh et al.,
1985). Note that percentile intervals can also be considered; see
\code{percentile} for details.

\item When \code{statistic = "r"} or \code{statistic = "Pearson"}, the
Pearson correlation coefficient is calculated for \emph{two} pollutants.
The calculation involves a weighted Pearson correlation coefficient, which
is weighted by Gaussian kernels for wind direction an the radial variable
(by default wind speed). More weight is assigned to values close to a wind
speed-direction interval. Kernel weighting is used to ensure that all data
are used rather than relying on the potentially small number of values in a
wind speed-direction interval.

\item When \code{statistic = "Spearman"}, the Spearman correlation
coefficient is calculated for \emph{two} pollutants. The calculation
involves a weighted Spearman correlation coefficient, which is weighted by
Gaussian kernels for wind direction an the radial variable (by default wind
speed). More weight is assigned to values close to a wind speed-direction
interval. Kernel weighting is used to ensure that all data are used rather
than relying on the potentially small number of values in a wind
speed-direction interval.

\item \code{"robust_slope"} is another option for pair-wise statistics and
\code{"quantile.slope"}, which uses quantile regression to estimate the
slope for a particular quantile level (see also \code{tau} for setting the
quantile level).

\item \code{"york_slope"} is another option for pair-wise statistics which
uses the \emph{York regression method} to estimate the slope. In this
method the uncertainties in \code{x} and \code{y} are used in the
determination of the slope. The uncertainties are provided by
\code{x_error} and \code{y_error} --- see below.}}
    \item{\code{exclude.missing}}{Setting this option to \code{TRUE} (the default)
removes points from the plot that are too far from the original data. The
smoothing routines will produce predictions at points where no data exist
i.e. they predict. By removing the points too far from the original data
produces a plot where it is clear where the original data lie. If set to
\code{FALSE} missing data will be interpolated.}
    \item{\code{uncertainty}}{Should the uncertainty in the calculated surface be shown?
If \code{TRUE} three plots are produced on the same scale showing the
predicted surface together with the estimated lower and upper uncertainties
at the 95\% confidence interval. Calculating the uncertainties is useful to
understand whether features are real or not.  For example, at high wind
speeds where there are few data there is greater uncertainty over the
predicted values. The uncertainties are calculated using the GAM and
weighting is done by the frequency of measurements in each wind
speed-direction bin. Note that if uncertainties are calculated then the
type is set to "default".}
    \item{\code{percentile}}{If \code{statistic = "percentile"} then \code{percentile}
is used, expressed from 0 to 100. Note that the percentile value is
calculated in the wind speed, wind direction \sQuote{bins}. For this reason
it can also be useful to set \code{min.bin} to ensure there are a
sufficient number of points available to estimate a percentile. See
\code{quantile} for more details of how percentiles are calculated.

\code{percentile} is also used for the Conditional Probability Function
(CPF) plots. \code{percentile} can be of length two, in which case the
percentile \emph{interval} is considered for use with CPF. For example,
\code{percentile = c(90, 100)} will plot the CPF for concentrations between
the 90 and 100th percentiles. Percentile intervals can be useful for
identifying specific sources. In addition, \code{percentile} can also be of
length 3. The third value is the \sQuote{trim} value to be applied. When
calculating percentile intervals many can cover very low values where there
is no useful information. The trim value ensures that values greater than
or equal to the trim * mean value are considered \emph{before} the
percentile intervals are calculated. The effect is to extract more detail
from many source signatures. See the manual for examples. Finally, if the
trim value is less than zero the percentile range is interpreted as
absolute concentration values and subsetting is carried out directly.}
    \item{\code{weights}}{At the edges of the plot there may only be a few data points
in each wind speed-direction interval, which could in some situations
distort the plot if the concentrations are high. \code{weights} applies a
weighting to reduce their influence. For example and by default if only a
single data point exists then the weighting factor is 0.25 and for two
points 0.5. To not apply any weighting and use the data as is, use
\code{weights = c(1, 1, 1)}.

An alternative to down-weighting these points they can be removed
altogether using \code{min.bin}.}
    \item{\code{min.bin}}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2 valid
records in each bin an so on; bins with less than 2 valid records are set
to NA. Care should be taken when using a value > 1 because of the risk of
removing real data points. It is recommended to consider your data with
care. Also, the \code{polarFreq} function can be of use in such
circumstances.}
    \item{\code{mis.col}}{When \code{min.bin} is > 1 it can be useful to show where data
are removed on the plots. This is done by shading the missing data in
\code{mis.col}. To not highlight missing data when \code{min.bin} > 1
choose \code{mis.col = "transparent"}.}
    \item{\code{upper}}{This sets the upper limit wind speed to be used. Often there are
only a relatively few data points at very high wind speeds and plotting all
of them can reduce the useful information in the plot.}
    \item{\code{force.positive}}{The default is \code{TRUE}. Sometimes if smoothing data
with steep gradients it is possible for predicted values to be negative.
\code{force.positive = TRUE} ensures that predictions remain positive. This
is useful for several reasons. First, with lots of missing data more
interpolation is needed and this can result in artefacts because the
predictions are too far from the original data. Second, if it is known
beforehand that the data are all positive, then this option carries that
assumption through to the prediction. The only likely time where setting
\code{force.positive = FALSE} would be if background concentrations were
first subtracted resulting in data that is legitimately negative. For the
vast majority of situations it is expected that the user will not need to
alter the default option.}
    \item{\code{k}}{This is the smoothing parameter used by the \code{gam} function in
package \code{mgcv}. Typically, value of around 100 (the default) seems to
be suitable and will resolve important features in the plot. The most
appropriate choice of \code{k} is problem-dependent; but extensive testing
of polar plots for many different problems suggests a value of \code{k} of
about 100 is suitable. Setting \code{k} to higher values will not tend to
affect the surface predictions by much but will add to the computation
time. Lower values of \code{k} will increase smoothing. Sometimes with few
data to plot \code{polarPlot} will fail. Under these circumstances it can
be worth lowering the value of \code{k}.}
    \item{\code{normalise}}{If \code{TRUE} concentrations are normalised by dividing by
their mean value. This is done \emph{after} fitting the smooth surface.
This option is particularly useful if one is interested in the patterns of
concentrations for several pollutants on different scales e.g. NOx and CO.
Often useful if more than one \code{pollutant} is chosen.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
    \item{\code{ws_spread}}{The value of sigma used for Gaussian kernel weighting of
wind speed when \code{statistic = "nwr"} or when correlation and regression
statistics are used such as \emph{r}. Default is \code{0.5}.}
    \item{\code{wd_spread}}{The value of sigma used for Gaussian kernel weighting of
wind direction when \code{statistic = "nwr"} or when correlation and
regression statistics are used such as \emph{r}. Default is \code{4}.}
    \item{\code{x_error}}{The \code{x} error / uncertainty used when \code{statistic =
"york_slope"}.}
    \item{\code{y_error}}{The \code{y} error / uncertainty used when \code{statistic =
"york_slope"}.}
    \item{\code{kernel}}{Type of kernel used for the weighting procedure for when
correlation or regression techniques are used. Only \code{"gaussian"} is
supported but this may be enhanced in the future.}
    \item{\code{formula.label}}{When pair-wise statistics such as regression slopes are
calculated and plotted, should a formula label be displayed?
\code{formula.label} will also determine whether concentration information
is printed when \code{statistic = "cpf"}.}
    \item{\code{tau}}{The quantile to be estimated when \code{statistic} is set to
\code{"quantile.slope"}. Default is \code{0.5} which is equal to the median
and will be ignored if \code{"quantile.slope"} is not used.}
    \item{\code{plot}}{Should a plot be produced? \code{FALSE} can be useful when
analysing data to extract plot components and plotting them in other ways.}
  }}

\item{control}{\strong{Deprecated.} Please use \code{type}.}
}
\value{
Either:
\itemize{
\item \emph{Dynamic:} A leaflet object
\item \emph{Static:} A \code{ggplot2} object using \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} coordinates with a \code{ggspatial} basemap
}
}
\description{
The \code{\link[=diffMap]{diffMap()}} function creates a map using bivariate polar plots as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be created using \code{type}. By
default, these maps are dynamic and can be panned, zoomed, and otherwise
interacted with. Using the \code{static} argument allows for static images to be
produced instead.
}
\section{Customisation of static maps using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\examples{
\dontrun{
# NB: "after" is some dummy data to demonstrate functionality
diffMap(
  before = polar_data,
  after = dplyr::mutate(polar_data, nox = jitter(nox, factor = 5)),
  pollutant = "nox"
)
}
}
\seealso{
\code{\link[openair:polarDiff]{openair::polarDiff()}}

Other directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()},
\code{\link{windroseMap}()}
}
\concept{directional analysis maps}
