% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{ProcessGraphArgument}
\alias{ProcessGraphArgument}
\title{ProcessGraphArgument}
\value{
Object of \code{\link[R6:R6Class]{R6::R6Class()}} representing a ProcessGraph.
}
\description{
Inheriting from \link{Argument} in order to represent an argument that contains a process or a derivable value (formerly known
as callback). The ProcessGraphArgument operates on the reduced data of a data cube. For example reducing or aggregating over
the temporal dimension results in a time series that has to be reduced into a single value or aggregated into another time
series. The value of a ProcessGraphArgument is usually a function that will be coerced into \code{\link[=Process]{Process()}}. The function
is required to use the same amount of parameters as \code{ProcessGraphParameter} objects are defined, because during the coercion
those \code{ProcessGraphParameter} are passed to function. Additional information can be found in the openEO API documentation:
\itemize{
\item \url{https://api.openeo.org/#section/Processes/Process-Graphs}
}
}
\section{Methods}{

\describe{
\item{\verb{$getProcessGraphParameters()}}{returns the available list \link{ProcessGraphParameter}}
\item{\verb{$setProcessGraphParameters(parameters)}}{assigns a list of \link{ProcessGraphParameter} to the ProcessGraph}
}
}

\section{Arguments}{

\describe{
\item{\code{parameters}}{the \link{ProcessGraphParameter} list}
}
}

\seealso{
\link{Array}, \link{Integer}, \link{EPSGCode}, \link{String}, \link{Number},
\link{Date}, \link{DataCube}, \link{ProcessGraphArgument},
\link{ProcessGraphParameter}, \link{OutputFormatOptions}, \link{GeoJson},
\link{Boolean}, \link{DateTime}, \link{Time}, \link{BoundingBox}, \link{Kernel},
\link{TemporalInterval}, \link{TemporalIntervals}, \link{CollectionId}, \link{OutputFormat},
\link{AnyOf}, \link{ProjDefinition}, \link{UdfCodeArgument}, \link{UdfRuntimeArgument} and
\link{UdfRuntimeVersionArgument}, \link{MetadataFilter}
}
