% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elevation.R
\name{ors_elevation}
\alias{ors_elevation}
\title{Openrouteservice Elevation}
\usage{
ors_elevation(
  format_in = c("geojson", "point", "polyline", "encodedpolyline", "encodedpolyline6"),
  geometry,
  format_out = format_in,
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{format_in}{input format}

\item{geometry}{\verb{longitude, latitude} coordinate pairs}

\item{format_out}{output format}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/elevation}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
3D point or line geometry structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}

\itemize{
\item for \code{"sf"}, a simple features \code{\link[sf]{sf}} object.
}
}
\description{
Get elevation data for points or lines
}
\details{
A GeoJSON based service to query SRTM elevation for Point or LineString 2D
geometries and return 3D geometries in various formats.
}
\examples{
# These examples might require interaction to query the local keyring, or
# might fail due to network issues, so they are not run by default
\dontrun{
# point coordinates
coordinates <- c(13.349762, 38.11295)
try( ors_elevation("point", coordinates) )

# geojson as input
point <- '{ "type": "Point", "coordinates": [13.349762, 38.11295] }'
try( ors_elevation("geojson", point) )

# line geometry returned as encoded polyline
coordinates <- list(
  c(13.349762, 38.11295),
  c(12.638397, 37.645772)
)
try( ors_elevation("polyline", coordinates, format_out = "encodedpolyline") )
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
