% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{design_bakeoff}
\alias{design_bakeoff}
\title{A visualiation for comparing slope-divided-by-intercept estimates
for a number of designs}
\usage{
design_bakeoff(
  xmin,
  xmax,
  designs,
  gen_resp = function(xs) {
     1 + 2 * xs + rnorm(length(xs), 0, 1)
 },
  Nsim = 1000,
  l_quantile_display = 0.01,
  u_quantile_display = 0.99,
  error_est = function(est) {
     quantile(est, 0.99) - quantile(est, 0.01)
 },
  num_digits_round = 3,
  draw_theta_at = NULL,
  xlab_names = NULL,
  ...
)
}
\arguments{
\item{xmin}{The minimum value of the independent variable.}

\item{xmax}{The maximum value of the independent variable.}

\item{designs}{A d x n matrix where each of the d rows is a design (the x values
used to run the experiment).}

\item{gen_resp}{A model for the response which takes the design as its parameter.}

\item{Nsim}{The number of estimates per design. Default is \code{1000}.}

\item{l_quantile_display}{The lowest quantile of the simulation estimates displayed. Default is \code{0.025}.}

\item{u_quantile_display}{The highest quantile of the simulation estimates displayed. Default is \code{0.975}.}

\item{error_est}{The error metric for the estimates. The sample standard deviation (i.e. \code{sd}) 
is unstable at low sample sizes. The default is the 90 percentile minus the 10 percentile.}

\item{num_digits_round}{The number of digits to round the error results. Default is 2.}

\item{draw_theta_at}{If the user wishes to draw a horizontal line marking theta (to checked biasedness)
it is specified here. The default is \code{NULL} with no line being drawn.}

\item{xlab_names}{Text for the x-grid labels. This vector's size should equal \code{lenth(designs)}.}

\item{...}{Additional arguments passed to the \code{boxplot} function.}
}
\value{
A list with the simulated estimates and error estimates for each design.
}
\description{
A visualiation for comparing slope-divided-by-intercept estimates
for a number of designs
}
\examples{
xmin = 5 / 15
xmax = 19 / 1
n = 10 #must be even for this demo
designs = rbind(
  c(rep(xmin, n / 2), rep(xmax, n / 2)),       #design A
  seq(from = xmin, to = xmax, length.out = n)  #design B
)
design_bakeoff_info = design_bakeoff(xmin, xmax, designs) #design A wins
}
\author{
Adam Kapelner
}
