% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{dsaugment_design}
\alias{dsaugment_design}
\title{Ds-Augment Design}
\usage{
dsaugment_design(
  init_design,
  alpha,
  model,
  parameters,
  par_values,
  par_int,
  design_space,
  calc_optimal_design,
  weight_fun = function(x) 1
)
}
\arguments{
\item{init_design}{dataframe with "Point" and "Weight" columns that represents the initial design to augment}

\item{alpha}{combined weight of the new points}

\item{model}{formula that represents the model with x as the independent variable}

\item{parameters}{character vector with the unknown parameters of the model to estimate}

\item{par_values}{numeric vector with the initial values of the unknown parameters}

\item{par_int}{optional numeric vector with the index of the \code{parameters} of interest for Ds-optimality.}

\item{design_space}{numeric vector with the limits of the space of the design}

\item{calc_optimal_design}{boolean parameter, if TRUE, the optimal design is calculated and efficiencies of the initial and augmented design are given}

\item{weight_fun}{optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response}
}
\value{
A dataframe that represents the Ds-augmented design
}
\description{
Ds-Augments a design. The user gives an initial design for which he would like to add points
and specifies the weight of the new points. Then he is prompted to choose a
minimum efficiency. After that, the candidate points region is calculated
and the user can choose the points and weights to add.
}
\examples{
init_des <- data.frame("Point" = c(30, 60, 90), "Weight" = c(1/3, 1/3, 1/3))
augment_design("Ds-Optimality", init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), par_int = c(1), TRUE)
augment_design("Ds-Optimality", init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), par_int = c(1), FALSE)

}
\seealso{
Other augment designs: 
\code{\link{daugment_design}()},
\code{\link{laugment_design}()}
}
\concept{augment designs}
