% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{total_daily_cost}
\alias{total_daily_cost}
\title{Compute the total daily cost of raising hatchery fish}
\usage{
total_daily_cost(
  time,
  recruits,
  daily_cost,
  init_cost = 0,
  time_slope = 0,
  time_exp = 1,
  rec_slope = 1,
  rec_exp = 1,
  type = "multiplicative"
)
}
\arguments{
\item{time}{The time at which fish are raised in hatchery}

\item{recruits}{The number of recruits raised}

\item{daily_cost}{Baseline daily cost to raise a single fish}

\item{init_cost}{An intercept on the total cost function}

\item{time_slope}{The slope term on the amount of time (see details)}

\item{time_exp}{The exponent on the amount of time}

\item{rec_slope}{The slope term on the number of recruits}

\item{rec_exp}{The exponent on the number of recruits}

\item{type}{Either multiply the number of recruits times the cost-at-time or
add to it (see Details).}
}
\value{
The total cost across time to raise the number of \code{recruits}.
This is simply the integral from time t = 0 until \code{time} of the
\code{\link{daily_cost_fun}} function.
}
\description{
This function takes the definite integral from time t = 0 until the
given \code{time} of the \code{\link{daily_cost_fun}}.
This integral is then the total cost of raising x number of fish until
\code{time} given the other cost function parameters.
}
\examples{
# total cost of raising 1000 fish for 100 days at given parameters
total_daily_cost(time = 100, recruits = 100,
           daily_cost = 0.05,
           time_slope = 0.01, time_exp = 1.2,
           rec_slope = 0.05, rec_exp = 1)
}
