% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_other_names}
\alias{orcid_other_names}
\title{Retrieve other names from ORCID}
\usage{
orcid_other_names(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this name}
\item{other_name}{Alternative name}
}
Returns an empty data.table with the same structure if no other names
are found.
}
\description{
Fetches alternative names (also known as, published as, etc.) associated
with an ORCID record.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/other-names}
}
\examples{
\dontrun{
# Fetch other names
other_names <- orcid_other_names("0000-0002-1825-0097")
print(other_names)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}
}
