% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_person}
\alias{orcid_person}
\title{Retrieve complete person data from ORCID}
\usage{
orcid_person(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.
Most public data is accessible without authentication.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{given_names}{Given (first) name}
\item{family_name}{Family (last) name}
\item{credit_name}{Published/credit name (if provided)}
\item{biography}{Biography text}
\item{keywords}{Comma-separated research keywords}
\item{researcher_urls}{Comma-separated professional URLs}
\item{country}{Country of residence}
}
Returns a data.table with NA values for missing fields.
}
\description{
Fetches comprehensive personal information including name, biography,
keywords, researcher URLs, and other public profile data from an ORCID record.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/person}

This endpoint provides the most comprehensive biographical information in a
single request, including name, biography, keywords, URLs, addresses, emails,
and external identifiers.
}
\examples{
\dontrun{
# Fetch complete person data
person <- orcid_person("0000-0002-1825-0097")
print(person)

# Access specific fields
person$biography
person$keywords

# With authentication
Sys.setenv(ORCID_TOKEN = "your-token-here")
person <- orcid_person("0000-0002-1825-0097")
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_bio}}, \code{\link{orcid_keywords}}, \code{\link{orcid_researcher_urls}}
}
