% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{orcid_search}
\alias{orcid_search}
\title{User-friendly ORCID search}
\usage{
orcid_search(
  given_name = NULL,
  family_name = NULL,
  affiliation_org = NULL,
  email = NULL,
  keywords = NULL,
  digital_object_ids = NULL,
  other_name = NULL,
  credit_name = NULL,
  rows = 10,
  start = 0,
  token = NULL,
  ...
)
}
\arguments{
\item{given_name}{Character string. Given (first) name to search for.}

\item{family_name}{Character string. Family (last) name to search for.}

\item{affiliation_org}{Character string. Organization name.}

\item{email}{Character string. Email address (supports wildcards like *@example.org).}

\item{keywords}{Character vector. One or more keywords to search for.}

\item{digital_object_ids}{Character string. DOI or DOI pattern.}

\item{other_name}{Character string. Alternative name.}

\item{credit_name}{Character string. Credit/published name.}

\item{rows}{Integer. Number of results to return (default: 10).}

\item{start}{Integer. Starting position for pagination (default: 0).}

\item{token}{Character string or NULL. Optional API token.}

\item{...}{Additional parameters passed to \code{\link{orcid}}.}
}
\value{
A data.table of search results (same structure as \code{\link{orcid}}).
The total number of matches is available as \code{attr(result, "found")}.
}
\description{
Search for ORCID profiles using named parameters instead of Solr query
syntax. This function provides a more intuitive interface than \code{\link{orcid}}.
}
\details{
This function constructs a Solr query from the provided parameters and
calls \code{\link{orcid}} internally. Multiple parameters are combined
with AND logic. Uses the expanded-search endpoint to return name information.
}
\examples{
\dontrun{
# Search by name
results <- orcid_search(
  family_name = "Fabbri",
  given_name = "Lorenzo"
)

# Search by affiliation
results <- orcid_search(affiliation_org = "Stanford University")

# Search by keywords
results <- orcid_search(keywords = c("machine learning", "genomics"))

# Combine multiple criteria
results <- orcid_search(
  family_name = "Smith",
  affiliation_org = "Harvard",
  rows = 20
)
}

}
\seealso{
\code{\link{orcid}} for more flexible query syntax
}
