% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordDisp-method.R
\docType{methods}
\name{plotordDisp}
\alias{plotordDisp}
\title{Visualization of Estimated Effects}
\usage{
plotordDisp(
  x,
  names,
  colorvec,
  reference = NULL,
  labels = NULL,
  cex = 1,
  KI = FALSE,
  KIfactor = 10/11,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{\link[ordDisp]{ordDisp}}}

\item{names}{Names of the variables that shall be plotted}

\item{colorvec}{Vector of colors that are used for plotting (same length as names)}

\item{reference}{Optional name of reference with estimate \eqn{(\alpha,\beta)=(0,0)} (for categorical covariates)}

\item{labels}{Optional names that are used as labels in the plot (same length as names)}

\item{cex}{Global argument to set the size of all the labels in the plot}

\item{KI}{If true, pointwise 95\% confidence intervals are included in the plot}

\item{KIfactor}{Ratio that is used to plot the stars that represent confidence intervals (only if \code{KI=TRUE})}

\item{title}{Optional title that is added to the plot}

\item{...}{Further arguments passed to or from other methods}
}
\description{
A function to visualize the estimated effects of the location-shift model or rating-scale model accounting for response styles
(RSRS) obtained by \code{ordDisp}. In case of linear effects, the function returns a two-dimensional plot of the tupel \eqn{(exp{\alpha},exp{\beta}}. 
It is optional to include pointwise 95\% confidence intervals represented by stars, where the horizontal and vertical 
length correspond to the confidence intervals of \eqn{exp{\alpha}} (dispersion or response-style effect) and \eqn{exp{\beta}} 
(location or content-related effect). In case of smooth effects, the function returns two plots of the fitted (non-linear) functions \eqn{f(\beta)} 
and \eqn{f(\alpha)}.
}
\examples{
data(reti)

mod <- ordDisp(RET~SM+DIAB+GH+BP|SM+DIAB,data=reti,family="cumulative")
plot(mod,names=c("SM","DIAB"),colorvec=c(1,2))
plotvglm(mod)

mod2 <- ordDisp(RET~SM+s(DIAB)+GH+BP|SM+DIAB+GH+BP, data=reti, 
family="cumulative", n_bs=4, scaling=FALSE)
plot(mod2, names=c("DIAB"))

}
\references{
Tutz, Gerhard and Berger, Moritz (2016): Response Styles in Rating Scales - Simultaneous Modelling of 
Content-Related Effects and the Tendency to Middle or Extreme Categories, 
Journal of Educational and Behavioral Statistics 41(3), 239-268.

Tutz, Gerhard and Berger, Moritz (2017): Seperating Location and Dispersion in Ordinal Regression Models,
Econometrics and Statistics 2, 131-148.

Tutz, Gerhard and Berger, Moritz (2022): Sparser Ordinal Regression Models Based on Parametric and Additive Location-Shift
Approaches. International Statistical Review, 90(2), 306-327.
}
\seealso{
\code{\link[ordDisp]{ordDisp}}
}
\author{
Moritz Berger <Moritz.Berger@imbie.uni-bonn.de> \cr \url{https://www.imbie.uni-bonn.de/people/dr-moritz-berger/}
}
