% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_association.R
\name{Goodman_model_ii_star}
\alias{Goodman_model_ii_star}
\title{Fits Goodman's (1979) model II*, where row and column effects are equal.}
\usage{
Goodman_model_ii_star(
  n,
  exclude_diagonal = FALSE,
  max_iter = 25,
  verbose = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{exclude_diagonal}{should the cells of the main diagonal be excluded?
Default is FALSE, include all cells}

\item{max_iter}{maximum number of iterations}

\item{verbose}{should cycle-by-cycle information be printed out?
Default is FALSE, do not print}
}
\value{
a list containing
   alpha: vector of alpha (row) parameters
   beta: vector of beta (column) parameters
   phi: vector of common row/column effects
   log_likelihood: value of the log(likelihood) function at completion
   g_squared: G^2 fit measure
   chisq: X^2 fit measure
   df: degrees of freedom
}
\description{
Fits Goodman's (1979) model II*, where row and column effects are equal.
}
