# Tests of Goodman's simple association models

test_that("null association gives right fit statistics", {
  null_result <- Goodman_null_association(mental_health)
  expect_true(abs(null_result$g_squared - 47.42) <= 0.005,
              info=paste("G^2 null association", 47.42, null_result$g_squared))
  expect_true(abs(null_result$chisq - 45.99) <= 0.005,
              info=paste("X^2 null association", 45.99, null_result$chisq))
  expect_equal(null_result$df, 15)
}
)


test_that("uniform association gives right fit statistics", {
  uniform_result <- Goodman_uniform_association(mental_health)
  expect_true(abs(uniform_result$g_squared - 9.89) <= 0.006,
              info=paste("G^2 uniform association", 9.89, uniform_result$g_squared))
  expect_true(abs(uniform_result$chisq - 9.73) <= 0.005,
              info=paste("X^2 uniform association", 9.73, uniform_result$chisq))
  expect_equal(uniform_result$df, 14)
}
)


test_that("row effects gives right fit statistics", {
  row_result <- Goodman_model_i(mental_health, row_effects=TRUE, column_effects=FALSE)
  expect_true(abs(row_result$g_squared - 6.28) <= 0.005,
              info=paste("G^2 row association", 6.28, row_result$g_squared))
  expect_true(abs(row_result$chisq - 6.29) <= 0.005,
              info=paste("X^2 row association", 6.29, row_result$chisq))
  expect_equal(row_result$df, 12)
}
)


test_that("column effects gives right fit statistics", {
  column_result <- Goodman_model_i(mental_health, row_effects=FALSE, column_effects=TRUE)
  expect_true(abs(column_result$g_squared - 6.83) <= 0.005,
              info=paste("G^2 column association", 6.83, column_result$g_squared))
  expect_true(abs(column_result$chisq - 6.78) <= 0.005,
              info=paste("X^2 column association", 6.78, column_result$chisq))
  expect_equal(column_result$df, 10)
}
)


test_that("row and column Model I gives right fit statistics", {
  row_and_column_result_i <- Goodman_model_i(mental_health, row_effects=TRUE,
                                             column_effects=TRUE)
  expect_true(abs(row_and_column_result_i$g_squared - 3.04) <= 0.006,
              info=paste("G^2 row and column Model I", 3.04, row_and_column_result_i$g_squared))
  expect_true(abs(row_and_column_result_i$chisq - 3.06) <= 0.005,
              info=paste("X^2 row and column Model I", 3.06, row_and_column_result_i$chisq))
  expect_equal(row_and_column_result_i$df, 8)
}
)


test_that("null association gives right fit statistics, table 3", {
  null_result <- Goodman_null_association(social_status2, exclude_diagonal = TRUE)
  expect_true(abs(null_result$g_squared - 446.84) <= 0.006,
              info=paste("G^2 uniform association", 446.94, null_result$g_squared))
  expect_true(abs(null_result$chisq - 555.12) <= 0.005,
              info=paste("X^2 uniform association", 555.12, null_result$chisq))
  expect_equal(null_result$df, 41)
}
)


test_that("uniform association gives right fit statistics, table 3", {
  uniform_result <- Goodman_uniform_association(social_status2, exclude_diagonal = TRUE)
  expect_true(abs(uniform_result$g_squared - 58.44) <= 0.006,
              info=paste("G^2 uniform association", 58.44, uniform_result$g_squared))
  expect_true(abs(uniform_result$chisq - 55.77) <= 0.006, # value is 55.77507
              info=paste("X^2 uniform association", 55.77, uniform_result$chisq))
  expect_equal(uniform_result$df, 40)
}
)


test_that("row effects gives right fit statistics, table 3", {
  row_result <- Goodman_model_i(social_status2, row_effects=TRUE, column_effects=FALSE,
                                exclude_diagonal = TRUE)
  expect_true(abs(row_result$g_squared - 45.91) <= 0.005,
              info=paste("G^2 row association", 45.91, row_result$g_squared))
  expect_true(abs(row_result$chisq - 43.13) <= 0.005,
              info=paste("X^2 row association", 43.13, row_result$chisq))
  expect_equal(row_result$df, 34)
}
)


test_that("column effects gives right fit statistics, table 3", {
  column_result <- Goodman_model_i(social_status2, row_effects=FALSE, column_effects=TRUE,
                                   exclude_diagonal = TRUE)
  expect_true(abs(column_result$g_squared - 42.02) <= 0.005,
              info=paste("G^2 column association", 42.02, column_result$g_squared))
  expect_true(abs(column_result$chisq - 40.63) <= 0.005,
              info=paste("X^2 column association", 40.62, column_result$chisq))
  expect_equal(column_result$df, 34)
}
)


test_that("row and column Model I gives right fit statistics, table 3", {
  row_and_column_result_i <- Goodman_model_i(social_status2, row_effects=TRUE,
                                             column_effects=TRUE, exclude_diagonal=TRUE)
  expect_true(abs(row_and_column_result_i$g_squared - 30.52) <= 0.006,
              info=paste("G^2 row and column Model I", 30.52, row_and_column_result_i$g_squared))
  expect_true(abs(row_and_column_result_i$chisq - 29.28) <= 0.005,
              info=paste("X^2 row and column Model I", 29.28, row_and_column_result_i$chisq))
  expect_equal(row_and_column_result_i$df, 28)
}
)


test_that("row and column Model II gives right fit statistics, table 3", {
  row_and_column_result_ii <- Goodman_model_ii(social_status2, update_rows=TRUE,
                                               update_columns=TRUE,
                                               exclude_diagonal=TRUE)
  expect_true(abs(row_and_column_result_ii$g_squared - 29.15) <= 0.005,
              info=paste("G^2 row and column Model II", 29.15,
                         row_and_column_result_ii$g_squared))
  expect_true(abs(row_and_column_result_ii$chisq - 27.97) <= 0.005,
              info=paste("X^2 row and column Model II", 27.97,
                         row_and_column_result_ii$chisq))
  expect_equal(row_and_column_result_ii$df, 28)
}
)


test_that("row / column Model I* gives right fit statistics", {
  row_and_column_result_i_star <- Goodman_model_i_star(social_status2,
                                                       exclude_diagonal=TRUE)
  expect_true(abs(row_and_column_result_i_star$g_squared - 33.39) <= 0.005,
              info=paste("G^2 row and column Model I*", 33.39,
                         row_and_column_result_i_star$g_squared))
  expect_true(abs(row_and_column_result_i_star$chisq - 32.01) <= 0.005,
              info=paste("X^2 row and column Model I*", 32.01,
                         row_and_column_result_i_star$chisq))
  expect_equal(row_and_column_result_i_star$df, 34)
}
)


test_that("row and column Model II gives right fit statistics", {
  row_and_column_result_ii <- Goodman_model_ii(mental_health, update_rows=TRUE,
                                               update_columns=TRUE)
  expect_true(abs(row_and_column_result_ii$g_squared - 3.57) <= 0.005,
              info=paste("G^2 row and column Model II", 3.57, row_and_column_result_ii$g_squared))
  expect_true(abs(row_and_column_result_ii$chisq - 3.57) <= 0.005,
              info=paste("X^2 row and column Model II", 3.57, row_and_column_result_ii$chisq))
  expect_equal(row_and_column_result_ii$df, 8)
}
)


test_that("row / column Model II* gives right fit statistics", {
  row_and_column_result_ii_star <- Goodman_model_ii_star(social_status2,
                                                       exclude_diagonal=TRUE)
  expect_true(abs(row_and_column_result_ii_star$g_squared - 32.56) <= 0.005,
              info=paste("G^2 row and column Model II*", 32.56,
                         row_and_column_result_ii_star$g_squared))
  expect_true(abs(row_and_column_result_ii_star$chisq - 31.21) <= 0.005,
              info=paste("X^2 row and column Model II*", 31.21,
                         row_and_column_result_ii_star$chisq))
  expect_equal(row_and_column_result_ii_star$df, 34)
}
)


test_that("symmetry model gives right fit statistics", {
  symmetry_result <- Goodman_symmetric_association_model(social_status2)
  expect_true(abs(symmetry_result$g_squared - 22.93) <= 0.005,
              info=paste("G^2 symmetry model", 22.93, symmetry_result$g_squared))
  expect_true(abs(symmetry_result$chisq - 20.34) <= 0.005,
              info=paste("X^2 symmetry model", 20.34, symmetry_result$chisq))
  expect_equal(symmetry_result$df, 21)
}
)

