% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_user.R
\name{predict.orf}
\alias{predict.orf}
\title{Prediction of the Ordered Forest}
\usage{
\method{predict}{orf}(object, newdata = NULL, type = NULL, inference = NULL, ...)
}
\arguments{
\item{object}{estimated Ordered Forest object of class \code{orf}}

\item{newdata}{numeric matrix X containing the observations for which the outcomes should be predicted}

\item{type}{string, specifying the type of the prediction, These can be either "probs" or  "p" for probabilities and "class" or "c" for classes. (Default is "probs").}

\item{inference}{logical, if TRUE variances for the predictions will be estimated (only feasible for probability predictions).}

\item{...}{further arguments (currently ignored)}
}
\value{
object of class \code{orf.prediction} with following elements
      \item{info}{info containing forest inputs and data used}
      \item{predictions}{predicted values}
      \item{variances}{variances of predicted values}
}
\description{
Prediction for new observations based on estimated Ordered Forest of class \code{orf}
}
\details{
\code{predict.orf} estimates the conditional ordered choice probabilities,
i.e. P[Y=m|X=x] for new data points (matrix X containing new observations
of covariates) based on the estimated Ordered Forest object of class \code{orf}.
Furthermore, weight-based inference for the probability predictions can be
conducted as well. If inference is desired, the supplied Ordered Forest must be
estimated with honesty and subsampling. If prediction only is desired, estimation
without honesty and with bootstrapping is recommended for optimal prediction
performance. Additionally to the probability predictions, class predictions can
be estimated as well using the \code{type} argument. In this case, the predicted
classes are obtained as classes with the highest predicted probability.
}
\examples{
# Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates for train and test
idx <- sample(seq(1, nrow(odata), 1), 0.8*nrow(odata))

# train set
Y_train <- as.numeric(odata[idx, 1])
X_train <- as.matrix(odata[idx, -1])

# test set
Y_test <- as.numeric(odata[-idx, 1])
X_test <- as.matrix(odata[-idx, -1])

# estimate Ordered Forest
orf_fit <- orf(X_train, Y_train)

# predict the probabilities with the estimated orf
orf_pred <- predict(orf_fit, newdata = X_test)
\donttest{
# predict the probabilities with estimated orf together with variances
orf_pred <- predict(orf_fit, newdata = X_test, inference = TRUE)

# predict the classes with estimated orf
orf_pred <- predict(orf_fit, newdata = X_test, type = "class")
}

}
\seealso{
\code{\link{summary.orf.prediction}}, \code{\link{print.orf.prediction}}
}
\author{
Gabriel Okasa
}
