% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traversal.R
\name{bng_distance}
\alias{bng_distance}
\alias{bng_dwithin}
\title{Distance calculations}
\usage{
bng_dwithin(bng_ref, d, ...)

bng_distance(bng_ref1, bng_ref2, by_element = FALSE, edge_to_edge = FALSE)
}
\arguments{
\item{bng_ref}{object of class \code{BNGReference}.}

\item{d}{numeric. Distance expressed in metres.}

\item{...}{additional parameters. Not currently used.}

\item{bng_ref1, bng_ref2}{object of \code{BNGReference}}

\item{by_element}{logical. If \code{TRUE}, return a vector with distance
between each pair of BNG references. An error is raised if the
\code{BNGReference} objects are not the same length. Default is
\code{FALSE}, to return a dense matrix with all pairwise distances.}

\item{edge_to_edge}{Logical. Should the distances be measured between the
edges of the grid references? Default is \code{FALSE} to use the centroid.}
}
\value{
list containing an unordered vector of \code{BNGReference} objects
around a given grid square within an absolute distance \code{d}.

If \code{by_element} is \code{FALSE} \code{bng_distance} returns a
dense numeric matrix of dimension length(x) by length(y); otherwise it
returns a numeric vector the same length as \code{x} and \code{y} with an
error raised if the lengths of \code{x} and \code{y} are unequal. Distances
involving invalid references are \code{NA}.
}
\description{
Compute Euclidean distances between BNG references and distance-based
neighbours lists.
}
\details{
\code{bng_dwithin} returns all grids squares for which any part of the
boundary is within the distance \code{d} of any part of \code{bng_ref}'s
boundary.
}
\examples{
bng_dwithin(as_bng_reference("SU1234"), 1000)

bng_dwithin(as_bng_reference("SU1234"), 1001)


ref1 <- as_bng_reference("SE1433")

bng_distance(ref1, as_bng_reference("SE1631"))

bng_distance(ref1, as_bng_reference("SENW"))

ref2 <- as_bng_reference(c("SE1533", "SE1631", "SE"))

bng_distance(ref1, ref2)

bng_distance(ref2)

ref3 <- as_bng_reference(c("SE1433", "SE1244"))

bng_distance(ref3, ref2)

bng_distance(ref3, ref2[1:2], by_element = TRUE)

bng_distance(ref1, ref2, edge_to_edge = TRUE)

}
