% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bng.R
\name{print.BNGReference}
\alias{print.BNGReference}
\alias{format.BNGReference}
\title{Printing BNG References}
\usage{
\method{print}{BNGReference}(x, ...)

\method{format}{BNGReference}(x, compact = FALSE, ...)
}
\arguments{
\item{x}{An object of type \code{BNGReference}.}

\item{...}{Additional parameters.}

\item{compact}{Logical. Should standard spaces be added or removed for
"pretty" printing? Default is \code{FALSE} to add spaces.}
}
\value{
\itemize{
\item \code{format} provides a standard formatting of BNG reference objects
\item \code{print} outputs the BNG references and invisibly returns the object.
}
}
\description{
Supporting formatting and printing of \code{BNGReference} objects.
}
\details{
Standard spaces are added: 1) after the two-letter prefix, 2) between
eastings and northings, and 3) before a quadrant suffix, when those
components exist in a grid reference.
}
\examples{
x <- as_bng_reference("SU1234")
print(x)

print(x, compact = TRUE)

}
