% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{valid}
\alias{valid}
\alias{is_valid_bng}
\alias{is_valid_bng.character}
\alias{is_valid_bng.BNGReference}
\alias{is_valid_bng_resolution}
\title{Check validity of a BNG Reference}
\usage{
is_valid_bng(bng_ref)

\method{is_valid_bng}{character}(bng_ref)

\method{is_valid_bng}{BNGReference}(bng_ref)

is_valid_bng_resolution(resolution)
}
\arguments{
\item{bng_ref}{Input vector of the BNG reference string(s) to validate.}

\item{resolution}{Numeric or character vector of resolutions to test.}
}
\value{
Logical vector indicating for each reference of \code{bng_ref}
whether it is valid.

Logical vector testing resolution.
}
\description{
Validates a British National Grid reference string using a regular expression
pattern.

Helper function used to verify resolutions.
}
\details{
The BNG is structured using a hierarchical system of grid squares at various
resolutions. At its highest level, the grid is divided into 100 km by 100 km
squares, each of which is identified by a two-letter code. Successive levels
of resolution further subdivide the grid squares into finer detail, down to
individual 1-meter squares.

Each reference consists of a 2-letter prefix (identifying the 100 km grid
square), followed by an easting and northing value, which may be further
subdivided using intermediate resolutions. Additionally, an optional suffix
representing ordinal (intercardinal) directions (NE, SE, SW, NW) may be
appended to the reference to account for quadtree subdivision of the grid at
finer resolutions. The grid reference can be expressed at different scales,
as follows:
\enumerate{
\item 100 km: Identified by a two-letter code (e.g. 'TQ').
\item 50 km: Subdivides the 100 km grid into four quadrants.
The grid reference adds an ordinal direction suffix (NE, NW, SE, SW) to
indicate the quadrant within the 100 km square (e.g. 'TQSW').
\item 10 km: Adds two-digit easting and northing values (e.g. 'TQ23').
\item 5 km: Subdivides the 10 km square adding an ordinal suffix
(e.g. 'TQ53SW').
\item 1 km: Adds four-digit easting and northing values
(e.g. 'TQ2334').
\item 500 m: Subdivides the 1 km square adding an ordinal suffix
(e.g. 'TQ2334NE').
\item 100 m: Adds six-digit easting and northing values
(e.g. ' TQ238347').
\item 50 m: Subdivides the 100 m square adding an ordinal suffix
(e.g. 'TQ238347SE').
\item 10 m: Adds eight-digit easting and northing values
(e.g. 'TQ23863472').
\item 5 m: Subdivides the 10 m square adding an ordinal suffix
(e.g. e.g. 'TQ23863472NW').
\item 1 m: Adds ten-digit easting and northing values (e.g. 'TQ2386334729').
}

BNG references must adhere to the following format:
\itemize{
\item Whitespace may or may not separate  the components of the reference
(i.e. between the two-letter 100km grid square prefix, easting, northing,
and ordinal suffix).
\item If whitespace is present, it should be a single space character.
\item Whitespace can be inconsistently used between components of the reference.
\item The two-letter 100 km grid square prefixes and ordinal direction suffixes
(NE, SE, SW, NW) should be capitalised.
}

At each resolution, a given location can be identified with increasing
detail, allowing for variable accuracy depending on the geospatial
application, from small-scale mapping to precise survey measurements.
}
\examples{
is_valid_bng("TQ1234")  # TRUE

is_valid_bng("TQ123")  # FALSE

is_valid_bng("TQ 12 34")  # TRUE

is_valid_bng_resolution(1000)

is_valid_bng_resolution("1km")

is_valid_bng_resolution(0.5)

}
\seealso{
\code{\link[=as_bng_reference]{as_bng_reference()}}
}
