% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pharmacogenomicsChemblQuery.R
\name{pharmacogenomicsChemblQuery}
\alias{pharmacogenomicsChemblQuery}
\title{Retrieve Pharmacogenomics data for a specified drug.}
\usage{
pharmacogenomicsChemblQuery(chemblId)
}
\arguments{
\item{chemblId}{Character: ChEMBL ID of the target drug (e.g., "CHEMBL1016").}
}
\value{
Returns a tibble containing pharmacogenomics data for the specified drug.
}
\description{
This function queries the Open Targets GraphQL API to retrieve pharmacogenomics data
for a specified drug.
}
\examples{
\dontrun{
result <- pharmacogenomicsChemblQuery(chemblId = "CHEMBL1016")
}
}
