\name{otuReport}
\alias{otuReport}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Summarize the community structure and abundance with OTU table
}
\description{
The function will summarize the frequency, abundance at given taxonomic level for the input OTU table. This function could quickly give the summary information for user when adding these values in describing the community structure in a paper.
}
\usage{
otuReport(otutab, siteInCol = TRUE, taxhead = "taxonomy", platform = "mothur",
    pattern = ";", prefix = TRUE, percent = FALSE, taxlevel = "phylum",
    collap = ";")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{otutab}{
A OTU table of microbial community, which must contain a taxonomic column (if siteInCol) or row (if site in rows). The otu table can be given in numeric counts or in relative abundance.
}
  \item{siteInCol}{
Logical, if "TRUE", the OTU table contains samples in columns and taxa in rows. The function will decide whether to transpose the otu table based on this parameter.
}
  \item{taxhead}{
Character, specify the header of taxonomy. By default we assume your taxonomic column is entitled "taxonomy".
}
  \item{platform}{
Character, argument to specify the platform generating the otu table. Currently, the function support otu table generate by "mothur" or "qiime".
}
  \item{pattern}{
Character, specify the separation of taxonomy. By default, the taxonomy is separated by semicolon (";").
}
  \item{prefix}{
Logical, tell the function whether the output will include the prefix like "p__", "c__" for the corresponding taxonomic levels.
}
  \item{percent}{
Logical, whether the input otu table are given in relative abundance. FALSE means that the input otu table is in numeric counts.
}
  \item{taxlevel}{
Character, specify the taxonomic level at which you want to know for the otu table. The valid choice are c("kingdom", "phylum", "class", "order", "family", "genus", "species").
}
  \item{collap}{
Character, tell the function about the separation for the hierarchical order in the output.
}
}
\details{
This function was designed according to the structured taxonomy generated by mothur or qiime. So far, the function support the 7 levels of hierarchical taxonomy from kingdom to species.
}
\value{
If the input otu table is in counts, the function will return a list of results summarizing 9 different aspects for the microbial community as follows:
%%  If it is a LIST, use
\item{whatTaxa }{The "whatTaxa" will give which lineages are present at given taxonomic level in the community.}
\item{taxaFreqs }{The element of "taxaFreqs" in the list is the frequency table of each lineage when community table were collapsed at a given taxonomic level.}
\item{taxaFrac }{The "taxaFrac" element summarizes the fraction of each lineage among the total lineages at a given taxonomic level.}
\item{reads }{The "reads" table is the otu table in absolute counts which has been collapsed at a given taxonomic level.}
\item{readSum }{The "readSum" gives the total amount of reads in each sample after the community was collapsed at given taxonomic level.}
\item{readFrac }{The "readFrac" table give the fraction of reads in relation to the total counts of the whole community at given taxonomic level.}
\item{readFracSum }{The "readFracSum" table give sum of reads fraction by different lineages at given taxonomic level.}
\item{Relabund }{The "Relabund" is the relative abundance table in percentage at given taxonomic level. If the input otu table is in absolute counts, the reads will be normalized by the total amount of reads of each sample, not the total amount of the whole community.}
\item{RelabundMean }{The data "RelabundMean" in the list return the mean relative abundance of each lineage at given taxonomic level across all samples.}
For the relative abundance otu input, the function will omit four summary table regarding absolute reads ("reads", "readSum", "readFrac" and "readFracSum").
%% ...
}
\author{
Sizhong Yang <yanglzu@163.com>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
subOTU, otuCollap
}
\examples{
# summary the otu table in qiime format

data(otuqiime)

summaryInfo <- otuReport(otutab = otuqiime, siteInCol = TRUE, taxhead = "taxonomy",
    platform = "qiime", pattern = ";", prefix = TRUE, percent = FALSE, taxlevel = "class")

length(summaryInfo)
names(summaryInfo)
summaryInfo[[1]]

# summary otu table in mothur format

data(otumothur)

summaryInfo <- otuReport(otutab = otumothur, siteInCol = TRUE, taxhead = "taxonomy",
    platform = "mothur", pattern = ";", percent = FALSE, taxlevel = "phylum", collap = ";")

length(summaryInfo)
names(summaryInfo)
summaryInfo[[1]]

op <- par(mar = c(8,6,2,1)+0.1)
bplot(summaryInfo[["taxaFreqs"]])
par(op)

# summary otu table of relative abundance

per <- subOTU(otutab = otuqiime, siteInCol = TRUE, taxhead = "taxonomy",
    percent = FALSE, choose = "all", outype = "Relabund", sort = TRUE)

summaryInfo <- otuReport(otutab = per, siteInCol = TRUE, taxhead = "taxonomy",
    platform = "qiime", pattern = ";", percent = TRUE, taxlevel = "class")

length(summaryInfo)
names(summaryInfo)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{summarize }% use one of  RShowDoc('KEYWORDS')
