% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmspc.R
\name{kmspc}
\alias{kmspc}
\title{MULTISPATI-PCA clustering}
\usage{
kmspc(
  data,
  variables,
  number_cluster = 3:5,
  explainedVariance = 70,
  ldist = 0,
  udist = 40,
  center = TRUE,
  fuzzyness = 1.2,
  distance = "euclidean",
  zero.policy = FALSE,
  only_spca_results = TRUE,
  all_results = FALSE
)
}
\arguments{
\item{data}{sf object}

\item{variables}{variables to use for clustering, if missing, all numeric
variables will be used}

\item{number_cluster}{\code{numeric} vector with number of final clusters}

\item{explainedVariance}{\code{numeric} number in percentage of explained variance
from PCA analysis to keep and make cluster process}

\item{ldist}{\code{numeric} lower distance bound to identify neighbors}

\item{udist}{\code{numeric} upper distance bound to identify neighbors}

\item{center}{a logical or numeric value, centring option
if TRUE, centring by the mean
if FALSE no centring
if a numeric vector, its length must be equal to the number of
columns of the data frame df and gives the decentring}

\item{fuzzyness}{A number greater than 1 giving the degree of fuzzification.}

\item{distance}{\code{character} Must be one of the following:
If "euclidean", the mean square error, if "manhattan", the mean
absolute error is computed. Abbreviations are also accepted.}

\item{zero.policy}{default NULL, use global option value;
if FALSE stop with error for any empty neighbors sets,
if TRUE permit the weights list to be formed with zero-length
weights vectors}

\item{only_spca_results}{\code{logical}; should return both PCA and sPCA
results (\code{FALSE}), or only sPCA results (\code{TRUE})? This can be a
time consuming process if there are multiple variables.}

\item{all_results}{\code{logical}; should return the results from the
sPCA and PCA call?}
}
\value{
a list with classification results and indices to select best number of
clusters.
}
\description{
MULTISPATI-PCA clustering
}
\examples{
library(sf)
data(wheat, package = 'paar')

# Transform the data.frame into a sf object
wheat_sf <- st_as_sf(wheat,
                     coords = c('x', 'y'),
                     crs = 32720)

# Run the kmspc function
kmspc_results <- kmspc(wheat_sf,
                       number_cluster = 2:4)

# Print the summaryResults
kmspc_results$summaryResults

# Print the indices
kmspc_results$indices

# Print the cluster
head(kmspc_results$cluster, 5)

# Combine the results in a single object
wheat_clustered <- cbind(wheat_sf, kmspc_results$cluster)

# Plot the results
plot(wheat_clustered[, "Cluster_2"])
}
