% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt_template.R
\name{build_prompt}
\alias{build_prompt}
\title{Build a concrete LLM prompt from a template}
\usage{
build_prompt(template, trait_name, trait_desc, text1, text2)
}
\arguments{
\item{template}{Character string containing the prompt template.}

\item{trait_name}{Character scalar giving a short label for the trait
(e.g., "Overall Quality").}

\item{trait_desc}{Character scalar giving the full definition of the trait.}

\item{text1}{Character scalar containing the text for SAMPLE_1.}

\item{text2}{Character scalar containing the text for SAMPLE_2.}
}
\value{
A single character string containing the completed prompt.
}
\description{
This function takes a prompt template (typically from
\code{\link{set_prompt_template}}), a trait name and description,
and two writing samples, and fills in the required placeholders.
}
\details{
The template must contain the placeholders:
\code{{TRAIT_NAME}}, \code{{TRAIT_DESCRIPTION}},
\code{{SAMPLE_1}}, and \code{{SAMPLE_2}}.
}
\examples{
tmpl <- set_prompt_template()
td <- trait_description("overall_quality")
prompt <- build_prompt(
  template   = tmpl,
  trait_name = td$name,
  trait_desc = td$description,
  text1      = "This is sample 1.",
  text2      = "This is sample 2."
)
cat(substr(prompt, 1, 200), "...\n")

}
