% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairing.R
\name{sample_pairs}
\alias{sample_pairs}
\title{Randomly sample pairs of writing samples}
\usage{
sample_pairs(pairs, pair_pct = 1, n_pairs = NULL, seed = NULL)
}
\arguments{
\item{pairs}{A tibble with columns \code{ID1}, \code{text1},
\code{ID2}, and \code{text2}.}

\item{pair_pct}{Proportion of pairs to sample (between 0 and 1).
Defaults to 1 (all pairs).}

\item{n_pairs}{Optional integer specifying the maximum number of
pairs to sample.}

\item{seed}{Optional integer seed for reproducible sampling.}
}
\value{
A tibble containing the sampled rows of \code{pairs}.
}
\description{
This function samples a subset of rows from a pairs data frame
returned by \code{\link{make_pairs}}. You can specify either the
proportion of pairs to retain (\code{pair_pct}), the absolute number
of pairs (\code{n_pairs}), or both (in which case the minimum of the
two is used).
}
\examples{
samples <- tibble::tibble(
  ID   = c("S1", "S2", "S3", "S4"),
  text = paste("Sample", 1:4)
)
pairs_all <- make_pairs(samples)

# Sample 50\% of all pairs
sample_pairs(pairs_all, pair_pct = 0.5, seed = 123)

# Sample exactly 3 pairs
sample_pairs(pairs_all, n_pairs = 3, seed = 123)

# Using built-in examples and sample 10\% of all pairs
data("example_writing_samples")
pairs_ex <- make_pairs(example_writing_samples)
pairs_ex_sample <- sample_pairs(pairs_ex, pair_pct = 0.10, seed = 1)
nrow(pairs_ex_sample)

}
