% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pald_functions.R
\name{as_cohesion_matrix}
\alias{as_cohesion_matrix}
\title{Coerce a matrix to a cohesion matrix object}
\usage{
as_cohesion_matrix(c)
}
\arguments{
\item{c}{A matrix of cohesion values (see \code{\link{cohesion_matrix}}).}
}
\value{
Object of class \code{cohesion_matrix}
}
\description{
\code{as_cohesion_matrix()} converts an existing matrix into an object of class
\code{cohesion_matrix}.
}
\examples{
C <- matrix(
  c(0.25, 0.125, 0.125, 0,
   0.125, 0.25, 0, 0.125,
   0.125, 0, 0.25, 0.125,
   0, 0.125, 0.125, 0.25
), nrow = 4, byrow = TRUE)

class(C)

C <- as_cohesion_matrix(C)
class(C)
}
