% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_images.R
\name{ps1_image_url}
\alias{ps1_image_url}
\title{Get URL of images}
\usage{
ps1_image_url(
  ra,
  dec,
  size = 240,
  output_size = NULL,
  filters = "grizy",
  format = "jpg",
  color = FALSE
)
}
\arguments{
\item{ra}{ra position in degrees}

\item{dec}{dec position in degrees}

\item{size}{extracted image size in pixels (0.25 arcsec/pixel)}

\item{output_size}{output (display) image size in pixels (default = size).
output_size has no effect for fits format images.}

\item{filters}{string with filters to include}

\item{format}{data format (options are "jpg", "png" or "fits")}

\item{color}{if TRUE, creates a color image (only for jpg or png format). Default is return a list of URLs for single-filter grayscale images.}
}
\value{
string with the URL
}
\description{
Get URL of images
}
\examples{
\dontrun{
ps1_image_url(
ra = 83.633210,
dec = 22.014460,
size = 1280,
format = "jpg",
filters = "grz",
color = T)
}

}
