% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetSubdiag}
\alias{GetSubdiag}
\title{GetSubdiag}
\usage{
GetSubdiag(fname)
}
\arguments{
\item{fname}{The name of the file with the dissimilarity matrix in jmatrix binary format.}
}
\value{
The vector with the values under the main diagonal, sorted by columns (i.e.: m(2,1) .. m(n,1), m(3,2)..m(n,2),..., m(n-1,n))
}
\description{
Takes a symmetric matrix and returns a vector with all its elements under the main diagonal (without those at the diagonal itself)
Done as an instrumental function to check the PAM in package cluster. To be removed in final version of the package.
}
\examples{
Rns <- matrix(runif(49),nrow=7)
Rsym <- 0.5*(Rns+t(Rns))
rownames(Rsym) <- c("A","B","C","D","E","F","G")
colnames(Rsym) <- c("a","b","c","d","e","f","g")
tmpfile1=paste0(tempdir(),"/Rsymfloat.bin")
JWriteBin(Rsym,tmpfile1,dtype="float",dmtype="symmetric")
d<-GetSubdiag(tmpfile1)
Rsym
d
}
