% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ppsurv.R
\name{plot_ppsurv}
\alias{plot_ppsurv}
\title{Plotting percent-percent plots for parametric fitting of data}
\usage{
plot_ppsurv(data, dist, time = "time", censor = "censor")
}
\arguments{
\item{data}{A dataframe containing a time column and a censor column.}

\item{dist}{A string name for a distribution that has a corresponding density function and distribution function.
Examples include "norm", "lnorm", "exp", "weibull", "logis", "llogis", "gompertz", etc.}

\item{time}{The string name of the time column of the dataframe. Defaults to "time".}

\item{censor}{The string name of the censor column of the dataframe. Defaults to "censor".
The censor column must be a numeric indicator variable where complete times correspond
to a value of 1 and incomplete times correspond to 0.}
}
\description{
Creates percent-percent plot of right censored data given that it follows a specified parametric distribution.
}
\examples{
data("rearrest")
plot_ppsurv(rearrest, "weibull", time = "months")
plot_ppsurv(rearrest, "exp", time = "months")
}
