% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_region_series.R
\name{is_region_series}
\alias{is_region_series}
\title{Check the object is a valid region series}
\usage{
is_region_series(x, strict = FALSE)
}
\arguments{
\item{x}{a \code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} representing a time series of
regional reconstructions obtained from \code{\link[=region_series]{region_series()}}.}

\item{strict}{a boolean defining whether to preform a thorough test (see
description above for details).}
}
\value{
TRUE if the object is a region series
}
\description{
A region series is a \code{\link[terra:SpatRaster-class]{terra::SpatRasterDataset}} for which each sub-dataset
is a variable, and all variables have the same number of time steps.
}
\details{
The standard test only checks that all sub-datasets (each of which is a
\code{\link[terra:SpatRaster-class]{terra::SpatRaster}}) have the same number of layers. The more thorough test
(obtained with \emph{strict=TRUE}) actually checks that all variables have the
same identical time steps by comparing the result of \code{\link[terra:time]{terra::time()}} applied
to each variable.
}
