% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{rotate_tunnel}
\alias{rotate_tunnel}
\title{Rotate a tunnel so that perches are approximately aligned}
\usage{
rotate_tunnel(
  obj_name,
  all_heights_min = 0.11,
  all_heights_max = 0.3,
  perch1_len_min = -0.06,
  perch1_len_max = 0.06,
  perch2_len_min = 2.48,
  perch2_len_max = 2.6,
  perch1_wid_min = 0.09,
  perch1_wid_max = 0.31,
  perch2_wid_min = 0.13,
  perch2_wid_max = 0.35,
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"} that has been passed
through \code{relabel_viewr_axes()} and \code{gather_tunnel_data()} (or is
structured as though it has been passed through those functions).}

\item{all_heights_min}{Minimum perch height}

\item{all_heights_max}{Maximum perch height}

\item{perch1_len_min}{Minimum length value of perch 1}

\item{perch1_len_max}{Maximum length value of perch 1}

\item{perch2_len_min}{Minimum length value of perch 2}

\item{perch2_len_max}{Maximum length value of perch 2}

\item{perch1_wid_min}{Minimum width value of perch 1}

\item{perch1_wid_max}{Maximum width value of perch 1}

\item{perch2_wid_min}{Minimum width value of perch 2}

\item{perch2_wid_max}{Maximum width value of perch 2}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which data have
been rotated according to user specifications.
}
\description{
The rotation is applied about the height axis and affects tunnel length and
width only, i.e. no rotation of height.
}
\details{
The user first estimates the locations of the perches by specifying
bounds for where each perch is located. The function then computes the
center of each bounding box and estimates that to be the midpoint of each
perch. Then the center point of the tunnel (center between the perch
midpoints) is estimated. The angle between perch1_center,
tunnel_center_point, and arbitrary point along the length axis
(tunnel_center_point - 1 on length) is estimated. That angle is then used
to rotate the data, again only in the length and width dimensions. Height
is standardized by (approximate) perch height; values greater than 0 are
above the perch and values less than 0 are below the perch level.
}
\examples{
## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "trimmed" step before running rotate_tunnel().
motive_trimmed <-
  motive_data \%>\%
  relabel_viewr_axes() \%>\%
  gather_tunnel_data() \%>\%
  trim_tunnel_outliers()

## Now rotate the tunnel using default values
motive_rotated <-
  motive_trimmed \%>\%
  rotate_tunnel()

## The following attributes store information about
## how rotation & translation was applied
attr(motive_rotated, "rotation_degrees")
attr(motive_rotated, "rotation_radians")
attr(motive_rotated, "perch1_midpoint_original")
attr(motive_rotated, "perch1_midpoint_current")
attr(motive_rotated, "tunnel_centerpoint_original")
attr(motive_rotated, "perch2_midpoint_original")
attr(motive_rotated, "perch2_midpoint_current")
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other tunnel standardization functions: 
\code{\link{redefine_tunnel_center}()},
\code{\link{standardize_tunnel}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
\concept{tunnel standardization functions}
