% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_createSubjectProfileReport.R
\name{createSubjectProfileReport}
\alias{createSubjectProfileReport}
\title{Create subject profile report.}
\usage{
createSubjectProfileReport(
  listPlots,
  timeLim = NULL,
  timeAlign = "all",
  timeAlignPerSubject = "none",
  refLines = NULL,
  refLinesData = NULL,
  refLinesTimeVar = NULL,
  refLinesLabelVar = NULL,
  bookmarkData = NULL,
  bookmarkVar = NULL,
  subjectSortData = bookmarkData,
  subjectSortVar = bookmarkVar,
  subjectSortDecreasing = FALSE,
  subjectVar = "USUBJID",
  subjectSubset = NULL,
  subjectSubsetData = NULL,
  subjectSubsetVar = NULL,
  subjectSubsetValue = NULL,
  subjectSample = NULL,
  seed = 123,
  subset = NULL,
  outputFile = "subjectProfile.pdf",
  exportFigures = FALSE,
  reportPerSubject = FALSE,
  exportBatchSize = NULL,
  labelVars = NULL,
  maxNLines = NULL,
  shiny = FALSE,
  formatReport = subjectProfileReportFormat(),
  verbose = FALSE,
  nCores = 1
)
}
\arguments{
\item{listPlots}{nested list of plots, as returned by the \code{\link{subjectProfileTextPlot}},
\code{\link{subjectProfileEventPlot}}, \code{\link{subjectProfileIntervalPlot}} or
\code{\link{subjectProfileLinePlot}} functions.}

\item{timeLim}{Time limits, as a numeric vector of length 2,
or a list with time limits for each module,
or nested list with time limits for each module and subject.
If not specified, these are set to the time limits specified
when creating each module (stored in \code{attributes(x)$metaData$timeLim})
otherwise to the range defined by \code{timeAlign} and \code{timeAlignPerSubject}.
Note that this doesn't modify the geoms of the plots, it only extends the
axis range. So for interval module(s) if the specified \code{timeLim}
is smaller than the time limits in the input plot, no arrows are created in case than
the time goes above/below specified \code{timeLim} (the segment is cut).}

\item{timeAlign}{Character vector with time alignment across modules/subjects, either:
\itemize{
\item{'all' (by default): all plots have the same time limits}
\item{'none': each of the plot (module*subject) has its own time limits}
\item{character vector with names of the modules which
should have the same time limits
(should correspond to the names of \code{listPlots})}
}}

\item{timeAlignPerSubject}{Character vector, specifying if the plots
should be aligned (or not) across subjects
\itemize{
\item{'none' (by default): all modules to align
have the same time limit across subjects}
\item{'all': all modules to align
 have different time limits per subject}
\item{character vector with subset of the modules to align per subject
(should correspond to the names of \code{listPlots})}
}
Only the modules already specified in \code{timeAlign}
can be aligned by subject.}

\item{refLines}{(optional) nested list with details for reference line(s).
Each sublist contains:
\itemize{
\item{(required) 'label': string with label for the reference line}
\item{(required) 'time': unique time (x) coordinate for the reference line}
\item{(optional) 'color': color for the reference line,
'black' by default}
\item{(optional) 'linetype': linetype for the reference line,
'dotted' by default}
}}

\item{refLinesData}{data.frame with data from which the reference line(s) should be extracted}

\item{refLinesTimeVar}{string, variable of \code{refLinesData} with time for reference line(s)}

\item{refLinesLabelVar}{string, variable of \code{refLinesData} with label for reference line(s)}

\item{bookmarkData, bookmarkVar}{Data.frame with data containing information for the index,
and character vector with corresponding variable(s) of interest.
An index will be created at the end of the subject profile report.\cr
The index contains a section per variable, referencing the 
pages of the report containing subject profiles
for each category/variable.}

\item{subjectSortData}{Data.frame with data containing information on how the subjects 
should be sorted (by default same as \code{bookmarkData}):
\itemize{
\item{in the report, in case one single report is created for all subjects}
\item{for the export, in case \code{reportPerSubject} is TRUE}
}
This data should contain \code{subjectSortVar} and \code{subjectVar}.}

\item{subjectSortVar}{Character vector, 
variable(s) of \code{subjectSortData} indicating the order for the subjects in the report,
(by default same as \code{bookmarkVar}).}

\item{subjectSortDecreasing}{Logical, if TRUE (FALSE by default)
subjects are sorted based on decreasing order of \code{subjectSortVar}.}

\item{subjectVar}{String, variable of \code{data} with subject ID}

\item{subjectSubset}{subjectSubset (optional) Character vector with subjects of interest 
(available in \code{subjectVar}), NULL by default.}

\item{subjectSubsetData}{Data.frame used to select subset of subjects of interest.}

\item{subjectSubsetVar}{String with variable of \code{subjectSubsetData} 
that should be considered to filter subjects.
If not specified, all subjects available in \code{subjectSubsetData} are considered.}

\item{subjectSubsetValue}{Character vector with value(s) of \code{subjectSubsetVar}
of interest to filter subjects on.}

\item{subjectSample}{(optional) Integer of length 1
with number of random subject(s) that should be considered in the specified subset dataset.
By default, all specified subjects are considered (set to NULL).}

\item{seed}{(optional) Integer of length 1 with seed used to select random subjects 
if \code{subjectSample} is specified (123 by default).}

\item{subset}{Character vector with subjects of interest 
(among names of each list in \code{listPlots}).}

\item{outputFile}{string, path to the output report}

\item{exportFigures}{Logical, if TRUE (FALSE by default) the 
subject profile figures are also exported
in pdf format in a 'figures' folder.\cr
Figures are named as \code{[subjectID]-[page].pdf}}

\item{reportPerSubject}{Logical, if TRUE (FALSE by default)
export a subject profile report by subject.}

\item{exportBatchSize}{(optional) Integer, if specified, the
patient-profile reports are created by batch of this number of subjects.
This might speed up the export for a high number of subjects.
Only available if report is created by subject (\code{reportPerSubject} is TRUE)
and modules are not aligned across subjects (\code{timeAlignPerSubject} is: 'all').}

\item{labelVars}{Named character vector with variable labels 
(names are the variable code)}

\item{maxNLines}{Maximum number of lines for a combined plot,
to fit in the page height. \cr
When the different visualizations
are combined for each subject, they will be allocated 
to different pages if the number of lines of the combined visualization
is higher than this number.}

\item{shiny}{logical, set to TRUE (FALSE by default) 
if the report is generated from a Shiny application.
Messages during report creation will be included in the Shiny interface,
and it will be mentioned at the end of the report.
In this case, the \code{shiny} package should be available.}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{verbose}{logical, if TRUE print messages during execution}

\item{nCores}{Integer containing the number of cores used for the computation
(1 by default). If more than 1, computation is parallelized, in this case
the package \code{parallel} is required.}
}
\value{
The path(s) of the report(s) is returned invisibly, and the
report is created at the location
specified by \code{outputFile}.\cr
If the report is created by subject, 
the name of the exported subject profile is built as:
\code{[filename]-[subjectID].pdf}, with [filename] extracted from
\code{outputFile}.
Space and platform-specific file separator are replaced by
a dash in the filename.\cr
If no patient profiles are available in the input,
nothing is returned and a warning is triggered.
}
\description{
By default all subjects available in at least one module of \code{listPlots} are considered.
If only a set of subjects are of interest, these are specified either:
\itemize{
\item{directly with the subject IDs of interest via \code{subjectSubset}}
\item{by extracting subjects with a specific value (\code{subjectSubsetValue})
in a variable (\code{subjectSubsetVar}) in a specific dataset \code{subjectSubsetData}}
}
}
\author{
Laure Cougnaud
}
