% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_reserved_instances}
\alias{ec2_describe_reserved_instances}
\title{Describes one or more of the Reserved Instances that you purchased}
\usage{
ec2_describe_reserved_instances(
  OfferingClass = NULL,
  ReservedInstancesIds = NULL,
  DryRun = NULL,
  Filters = NULL,
  OfferingType = NULL
)
}
\arguments{
\item{OfferingClass}{Describes whether the Reserved Instance is Standard or Convertible.}

\item{ReservedInstancesIds}{One or more Reserved Instance IDs.

Default: Describes all your Reserved Instances, or only those otherwise
specified.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone where the Reserved
Instance can be used.
\item \code{duration} - The duration of the Reserved Instance (one year or
three years), in seconds (\code{31536000} | \code{94608000}).
\item \code{end} - The time when the Reserved Instance expires (for example,
2015-08-07T11:54:42.000Z).
\item \code{fixed-price} - The purchase price of the Reserved Instance (for
example, 9800.0).
\item \code{instance-type} - The instance type that is covered by the
reservation.
\item \code{scope} - The scope of the Reserved Instance (\code{Region} or
\verb{Availability Zone}).
\item \code{product-description} - The Reserved Instance product platform
description (\code{Linux/UNIX} | \verb{Linux with SQL Server Standard} |
\verb{Linux with SQL Server Web} | \verb{Linux with SQL Server Enterprise} |
\verb{SUSE Linux} | \verb{Red Hat Enterprise Linux} |
\verb{Red Hat Enterprise Linux with HA} | \code{Windows} |
\verb{Windows with SQL Server Standard} | \verb{Windows with SQL Server Web} |
\verb{Windows with SQL Server Enterprise}).
\item \code{reserved-instances-id} - The ID of the Reserved Instance.
\item \code{start} - The time at which the Reserved Instance purchase request
was placed (for example, 2014-08-07T11:54:42.000Z).
\item \code{state} - The state of the Reserved Instance (\code{payment-pending} |
\code{active} | \code{payment-failed} | \code{retired}).
\item \verb{tag:<key>} - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{usage-price} - The usage price of the Reserved Instance, per hour
(for example, 0.84).
}}

\item{OfferingType}{The Reserved Instance offering type. If you are using tools that predate
the 2011-11-01 API version, you only have access to the
\verb{Medium Utilization} Reserved Instance offering type.}
}
\description{
Describes one or more of the Reserved Instances that you purchased.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances/} for full documentation.
}
\keyword{internal}
