% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_email_address_metadata}
\alias{connect_update_email_address_metadata}
\title{Updates an email address metadata}
\usage{
connect_update_email_address_metadata(
  InstanceId,
  EmailAddressId,
  Description = NULL,
  DisplayName = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{EmailAddressId}{[required] The identifier of the email address.}

\item{Description}{The description of the email address.}

\item{DisplayName}{The display name of email address.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Updates an email address metadata. For more information about email addresses, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/create-email-address1.html}{Create email addresses} in the Amazon Connect Administrator Guide.

See \url{https://www.paws-r-sdk.com/docs/connect_update_email_address_metadata/} for full documentation.
}
\keyword{internal}
