% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftserverless_operations.R
\name{redshiftserverless_create_namespace}
\alias{redshiftserverless_create_namespace}
\title{Creates a namespace in Amazon Redshift Serverless}
\usage{
redshiftserverless_create_namespace(
  adminPasswordSecretKmsKeyId = NULL,
  adminUserPassword = NULL,
  adminUsername = NULL,
  dbName = NULL,
  defaultIamRoleArn = NULL,
  iamRoles = NULL,
  kmsKeyId = NULL,
  logExports = NULL,
  manageAdminPassword = NULL,
  namespaceName,
  redshiftIdcApplicationArn = NULL,
  tags = NULL
)
}
\arguments{
\item{adminPasswordSecretKmsKeyId}{The ID of the Key Management Service (KMS) key used to encrypt and store
the namespace's admin credentials secret. You can only use this
parameter if \code{manageAdminPassword} is true.}

\item{adminUserPassword}{The password of the administrator for the first database created in the
namespace.

You can't use \code{adminUserPassword} if \code{manageAdminPassword} is true.}

\item{adminUsername}{The username of the administrator for the first database created in the
namespace.}

\item{dbName}{The name of the first database created in the namespace.}

\item{defaultIamRoleArn}{The Amazon Resource Name (ARN) of the IAM role to set as a default in
the namespace.}

\item{iamRoles}{A list of IAM roles to associate with the namespace.}

\item{kmsKeyId}{The ID of the Amazon Web Services Key Management Service key used to
encrypt your data.}

\item{logExports}{The types of logs the namespace can export. Available export types are
\code{userlog}, \code{connectionlog}, and \code{useractivitylog}.}

\item{manageAdminPassword}{If \code{true}, Amazon Redshift uses Secrets Manager to manage the
namespace's admin credentials. You can't use \code{adminUserPassword} if
\code{manageAdminPassword} is true. If \code{manageAdminPassword} is false or not
set, Amazon Redshift uses \code{adminUserPassword} for the admin user
account's password.}

\item{namespaceName}{[required] The name of the namespace.}

\item{redshiftIdcApplicationArn}{The ARN for the Redshift application that integrates with IAM Identity
Center.}

\item{tags}{A list of tag instances.}
}
\description{
Creates a namespace in Amazon Redshift Serverless.

See \url{https://www.paws-r-sdk.com/docs/redshiftserverless_create_namespace/} for full documentation.
}
\keyword{internal}
