# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Well-Architected Tool
#'
#' @description
#' Well-Architected Tool
#' 
#' This is the *Well-Architected Tool API Reference*. The WA Tool API
#' provides programmatic access to the [Well-Architected
#' Tool](https://aws.amazon.com/well-architected-tool/) in the Amazon Web
#' Services Management Console. For information about the Well-Architected
#' Tool, see the [Well-Architected Tool User
#' Guide](https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- wellarchitected(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- wellarchitected()
#' svc$associate_lenses(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=wellarchitected_associate_lenses]{associate_lenses} \tab Associate a lens to a workload\cr
#'  \link[=wellarchitected_associate_profiles]{associate_profiles} \tab Associate a profile with a workload\cr
#'  \link[=wellarchitected_create_lens_share]{create_lens_share} \tab Create a lens share\cr
#'  \link[=wellarchitected_create_lens_version]{create_lens_version} \tab Create a new lens version\cr
#'  \link[=wellarchitected_create_milestone]{create_milestone} \tab Create a milestone for an existing workload\cr
#'  \link[=wellarchitected_create_profile]{create_profile} \tab Create a profile\cr
#'  \link[=wellarchitected_create_profile_share]{create_profile_share} \tab Create a profile share\cr
#'  \link[=wellarchitected_create_review_template]{create_review_template} \tab Create a review template\cr
#'  \link[=wellarchitected_create_template_share]{create_template_share} \tab Create a review template share\cr
#'  \link[=wellarchitected_create_workload]{create_workload} \tab Create a new workload\cr
#'  \link[=wellarchitected_create_workload_share]{create_workload_share} \tab Create a workload share\cr
#'  \link[=wellarchitected_delete_lens]{delete_lens} \tab Delete an existing lens\cr
#'  \link[=wellarchitected_delete_lens_share]{delete_lens_share} \tab Delete a lens share\cr
#'  \link[=wellarchitected_delete_profile]{delete_profile} \tab Delete a profile\cr
#'  \link[=wellarchitected_delete_profile_share]{delete_profile_share} \tab Delete a profile share\cr
#'  \link[=wellarchitected_delete_review_template]{delete_review_template} \tab Delete a review template\cr
#'  \link[=wellarchitected_delete_template_share]{delete_template_share} \tab Delete a review template share\cr
#'  \link[=wellarchitected_delete_workload]{delete_workload} \tab Delete an existing workload\cr
#'  \link[=wellarchitected_delete_workload_share]{delete_workload_share} \tab Delete a workload share\cr
#'  \link[=wellarchitected_disassociate_lenses]{disassociate_lenses} \tab Disassociate a lens from a workload\cr
#'  \link[=wellarchitected_disassociate_profiles]{disassociate_profiles} \tab Disassociate a profile from a workload\cr
#'  \link[=wellarchitected_export_lens]{export_lens} \tab Export an existing lens\cr
#'  \link[=wellarchitected_get_answer]{get_answer} \tab Get the answer to a specific question in a workload review\cr
#'  \link[=wellarchitected_get_consolidated_report]{get_consolidated_report} \tab Get a consolidated report of your workloads\cr
#'  \link[=wellarchitected_get_global_settings]{get_global_settings} \tab Global settings for all workloads\cr
#'  \link[=wellarchitected_get_lens]{get_lens} \tab Get an existing lens\cr
#'  \link[=wellarchitected_get_lens_review]{get_lens_review} \tab Get lens review\cr
#'  \link[=wellarchitected_get_lens_review_report]{get_lens_review_report} \tab Get lens review report\cr
#'  \link[=wellarchitected_get_lens_version_difference]{get_lens_version_difference} \tab Get lens version differences\cr
#'  \link[=wellarchitected_get_milestone]{get_milestone} \tab Get a milestone for an existing workload\cr
#'  \link[=wellarchitected_get_profile]{get_profile} \tab Get profile information\cr
#'  \link[=wellarchitected_get_profile_template]{get_profile_template} \tab Get profile template\cr
#'  \link[=wellarchitected_get_review_template]{get_review_template} \tab Get review template\cr
#'  \link[=wellarchitected_get_review_template_answer]{get_review_template_answer} \tab Get review template answer\cr
#'  \link[=wellarchitected_get_review_template_lens_review]{get_review_template_lens_review} \tab Get a lens review associated with a review template\cr
#'  \link[=wellarchitected_get_workload]{get_workload} \tab Get an existing workload\cr
#'  \link[=wellarchitected_import_lens]{import_lens} \tab Import a new custom lens or update an existing custom lens\cr
#'  \link[=wellarchitected_list_answers]{list_answers} \tab List of answers for a particular workload and lens\cr
#'  \link[=wellarchitected_list_check_details]{list_check_details} \tab List of Trusted Advisor check details by account related to the workload\cr
#'  \link[=wellarchitected_list_check_summaries]{list_check_summaries} \tab List of Trusted Advisor checks summarized for all accounts related to the workload\cr
#'  \link[=wellarchitected_list_lenses]{list_lenses} \tab List the available lenses\cr
#'  \link[=wellarchitected_list_lens_review_improvements]{list_lens_review_improvements} \tab List the improvements of a particular lens review\cr
#'  \link[=wellarchitected_list_lens_reviews]{list_lens_reviews} \tab List lens reviews for a particular workload\cr
#'  \link[=wellarchitected_list_lens_shares]{list_lens_shares} \tab List the lens shares associated with the lens\cr
#'  \link[=wellarchitected_list_milestones]{list_milestones} \tab List all milestones for an existing workload\cr
#'  \link[=wellarchitected_list_notifications]{list_notifications} \tab List lens notifications\cr
#'  \link[=wellarchitected_list_profile_notifications]{list_profile_notifications} \tab List profile notifications\cr
#'  \link[=wellarchitected_list_profiles]{list_profiles} \tab List profiles\cr
#'  \link[=wellarchitected_list_profile_shares]{list_profile_shares} \tab List profile shares\cr
#'  \link[=wellarchitected_list_review_template_answers]{list_review_template_answers} \tab List the answers of a review template\cr
#'  \link[=wellarchitected_list_review_templates]{list_review_templates} \tab List review templates\cr
#'  \link[=wellarchitected_list_share_invitations]{list_share_invitations} \tab List the share invitations\cr
#'  \link[=wellarchitected_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for a resource\cr
#'  \link[=wellarchitected_list_template_shares]{list_template_shares} \tab List review template shares\cr
#'  \link[=wellarchitected_list_workloads]{list_workloads} \tab Paginated list of workloads\cr
#'  \link[=wellarchitected_list_workload_shares]{list_workload_shares} \tab List the workload shares associated with the workload\cr
#'  \link[=wellarchitected_tag_resource]{tag_resource} \tab Adds one or more tags to the specified resource\cr
#'  \link[=wellarchitected_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
#'  \link[=wellarchitected_update_answer]{update_answer} \tab Update the answer to a specific question in a workload review\cr
#'  \link[=wellarchitected_update_global_settings]{update_global_settings} \tab Update whether the Amazon Web Services account is opted into organization sharing and discovery integration features\cr
#'  \link[=wellarchitected_update_integration]{update_integration} \tab Update integration features\cr
#'  \link[=wellarchitected_update_lens_review]{update_lens_review} \tab Update lens review for a particular workload\cr
#'  \link[=wellarchitected_update_profile]{update_profile} \tab Update a profile\cr
#'  \link[=wellarchitected_update_review_template]{update_review_template} \tab Update a review template\cr
#'  \link[=wellarchitected_update_review_template_answer]{update_review_template_answer} \tab Update a review template answer\cr
#'  \link[=wellarchitected_update_review_template_lens_review]{update_review_template_lens_review} \tab Update a lens review associated with a review template\cr
#'  \link[=wellarchitected_update_share_invitation]{update_share_invitation} \tab Update a workload or custom lens share invitation\cr
#'  \link[=wellarchitected_update_workload]{update_workload} \tab Update an existing workload\cr
#'  \link[=wellarchitected_update_workload_share]{update_workload_share} \tab Update a workload share\cr
#'  \link[=wellarchitected_upgrade_lens_review]{upgrade_lens_review} \tab Upgrade lens review for a particular workload\cr
#'  \link[=wellarchitected_upgrade_profile_version]{upgrade_profile_version} \tab Upgrade a profile\cr
#'  \link[=wellarchitected_upgrade_review_template_lens_review]{upgrade_review_template_lens_review} \tab Upgrade the lens review of a review template
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname wellarchitected
#' @export
wellarchitected <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .wellarchitected$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.wellarchitected <- list()

.wellarchitected$operations <- list()

.wellarchitected$metadata <- list(
  service_name = "wellarchitected",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "wellarchitected.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "WellArchitected",
  api_version = "2020-03-31",
  signing_name = "wellarchitected",
  json_version = "1.1",
  target_prefix = ""
)

.wellarchitected$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.wellarchitected$metadata, handlers, config, op)
}
