# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include chatbot_service.R
NULL

#' Links a resource (for example, a custom action) to a channel
#' configuration
#'
#' @description
#' Links a resource (for example, a custom action) to a channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_associate_to_configuration/](https://www.paws-r-sdk.com/docs/chatbot_associate_to_configuration/) for full documentation.
#'
#' @param Resource &#91;required&#93; The resource Amazon Resource Name (ARN) to link.
#' @param ChatConfiguration &#91;required&#93; The channel configuration to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname chatbot_associate_to_configuration
chatbot_associate_to_configuration <- function(Resource, ChatConfiguration) {
  op <- new_operation(
    name = "AssociateToConfiguration",
    http_method = "POST",
    http_path = "/associate-to-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$associate_to_configuration_input(Resource = Resource, ChatConfiguration = ChatConfiguration)
  output <- .chatbot$associate_to_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$associate_to_configuration <- chatbot_associate_to_configuration

#' Creates an AWS Chatbot configuration for Amazon Chime
#'
#' @description
#' Creates an AWS Chatbot configuration for Amazon Chime.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_create_chime_webhook_configuration/](https://www.paws-r-sdk.com/docs/chatbot_create_chime_webhook_configuration/) for full documentation.
#'
#' @param WebhookDescription &#91;required&#93; A description of the webhook. We recommend using the convention
#' `RoomName/WebhookName`.
#' 
#' For more information, see [Tutorial: Get started with Amazon
#' Chime](https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param WebhookUrl &#91;required&#93; The URL for the Amazon Chime webhook.
#' @param SnsTopicArns &#91;required&#93; The Amazon Resource Names (ARNs) of the SNS topics that deliver
#' notifications to AWS Chatbot.
#' @param IamRoleArn &#91;required&#93; A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param ConfigurationName &#91;required&#93; The name of the configuration.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#' @param Tags A map of tags assigned to a resource. A tag is a string-to-string map of
#' key-value pairs.
#'
#' @keywords internal
#'
#' @rdname chatbot_create_chime_webhook_configuration
chatbot_create_chime_webhook_configuration <- function(WebhookDescription, WebhookUrl, SnsTopicArns, IamRoleArn, ConfigurationName, LoggingLevel = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateChimeWebhookConfiguration",
    http_method = "POST",
    http_path = "/create-chime-webhook-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$create_chime_webhook_configuration_input(WebhookDescription = WebhookDescription, WebhookUrl = WebhookUrl, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, ConfigurationName = ConfigurationName, LoggingLevel = LoggingLevel, Tags = Tags)
  output <- .chatbot$create_chime_webhook_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$create_chime_webhook_configuration <- chatbot_create_chime_webhook_configuration

#' Creates a custom action that can be invoked as an alias or as a button
#' on a notification
#'
#' @description
#' Creates a custom action that can be invoked as an alias or as a button on a notification.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_create_custom_action/](https://www.paws-r-sdk.com/docs/chatbot_create_custom_action/) for full documentation.
#'
#' @param Definition &#91;required&#93; The definition of the command to run when invoked as an alias or as an
#' action button.
#' @param AliasName The name used to invoke this action in a chat channel. For example,
#' `@@aws run my-alias`.
#' @param Attachments Defines when this custom action button should be attached to a
#' notification.
#' @param Tags A map of tags assigned to a resource. A tag is a string-to-string map of
#' key-value pairs.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, subsequent retries with the same client token
#' returns the result from the original successful request.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the SDK.
#' @param ActionName &#91;required&#93; The name of the custom action. This name is included in the Amazon
#' Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname chatbot_create_custom_action
chatbot_create_custom_action <- function(Definition, AliasName = NULL, Attachments = NULL, Tags = NULL, ClientToken = NULL, ActionName) {
  op <- new_operation(
    name = "CreateCustomAction",
    http_method = "POST",
    http_path = "/create-custom-action",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$create_custom_action_input(Definition = Definition, AliasName = AliasName, Attachments = Attachments, Tags = Tags, ClientToken = ClientToken, ActionName = ActionName)
  output <- .chatbot$create_custom_action_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$create_custom_action <- chatbot_create_custom_action

#' Creates an AWS Chatbot configuration for Microsoft Teams
#'
#' @description
#' Creates an AWS Chatbot configuration for Microsoft Teams.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_create_microsoft_teams_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_create_microsoft_teams_channel_configuration/) for full documentation.
#'
#' @param ChannelId &#91;required&#93; The ID of the Microsoft Teams channel.
#' @param ChannelName The name of the Microsoft Teams channel.
#' @param TeamId &#91;required&#93; The ID of the Microsoft Teams authorized with AWS Chatbot.
#' 
#' To get the team ID, you must perform the initial authorization flow with
#' Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
#' the team ID from the console. For more information, see [Step 1:
#' Configure a Microsoft Teams
#' client](https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup)
#' in the *AWS Chatbot Administrator Guide*.
#' @param TeamName The name of the Microsoft Teams Team.
#' @param TenantId &#91;required&#93; The ID of the Microsoft Teams tenant.
#' @param SnsTopicArns The Amazon Resource Names (ARNs) of the SNS topics that deliver
#' notifications to AWS Chatbot.
#' @param IamRoleArn &#91;required&#93; A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param ConfigurationName &#91;required&#93; The name of the configuration.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#' @param GuardrailPolicyArns The list of IAM policy ARNs that are applied as channel guardrails. The
#' AWS managed `AdministratorAccess` policy is applied by default if this
#' is not set.
#' @param UserAuthorizationRequired Enables use of a user role requirement in your chat configuration.
#' @param Tags A map of tags assigned to a resource. A tag is a string-to-string map of
#' key-value pairs.
#'
#' @keywords internal
#'
#' @rdname chatbot_create_microsoft_teams_channel_configuration
chatbot_create_microsoft_teams_channel_configuration <- function(ChannelId, ChannelName = NULL, TeamId, TeamName = NULL, TenantId, SnsTopicArns = NULL, IamRoleArn, ConfigurationName, LoggingLevel = NULL, GuardrailPolicyArns = NULL, UserAuthorizationRequired = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMicrosoftTeamsChannelConfiguration",
    http_method = "POST",
    http_path = "/create-ms-teams-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$create_microsoft_teams_channel_configuration_input(ChannelId = ChannelId, ChannelName = ChannelName, TeamId = TeamId, TeamName = TeamName, TenantId = TenantId, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, ConfigurationName = ConfigurationName, LoggingLevel = LoggingLevel, GuardrailPolicyArns = GuardrailPolicyArns, UserAuthorizationRequired = UserAuthorizationRequired, Tags = Tags)
  output <- .chatbot$create_microsoft_teams_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$create_microsoft_teams_channel_configuration <- chatbot_create_microsoft_teams_channel_configuration

#' Creates an AWS Chatbot confugration for Slack
#'
#' @description
#' Creates an AWS Chatbot confugration for Slack.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_create_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_create_slack_channel_configuration/) for full documentation.
#'
#' @param SlackTeamId &#91;required&#93; The ID of the Slack workspace authorized with AWS Chatbot.
#' @param SlackChannelId &#91;required&#93; The ID of the Slack channel.
#' 
#' To get this ID, open Slack, right click on the channel name in the left
#' pane, then choose Copy Link. The channel ID is the 9-character string at
#' the end of the URL. For example, ABCBBLZZZ.
#' @param SlackChannelName The name of the Slack channel.
#' @param SnsTopicArns The Amazon Resource Names (ARNs) of the SNS topics that deliver
#' notifications to AWS Chatbot.
#' @param IamRoleArn &#91;required&#93; A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param ConfigurationName &#91;required&#93; The name of the configuration.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#' @param GuardrailPolicyArns The list of IAM policy ARNs that are applied as channel guardrails. The
#' AWS managed `AdministratorAccess` policy is applied by default if this
#' is not set.
#' @param UserAuthorizationRequired Enables use of a user role requirement in your chat configuration.
#' @param Tags A map of tags assigned to a resource. A tag is a string-to-string map of
#' key-value pairs.
#'
#' @keywords internal
#'
#' @rdname chatbot_create_slack_channel_configuration
chatbot_create_slack_channel_configuration <- function(SlackTeamId, SlackChannelId, SlackChannelName = NULL, SnsTopicArns = NULL, IamRoleArn, ConfigurationName, LoggingLevel = NULL, GuardrailPolicyArns = NULL, UserAuthorizationRequired = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/create-slack-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$create_slack_channel_configuration_input(SlackTeamId = SlackTeamId, SlackChannelId = SlackChannelId, SlackChannelName = SlackChannelName, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, ConfigurationName = ConfigurationName, LoggingLevel = LoggingLevel, GuardrailPolicyArns = GuardrailPolicyArns, UserAuthorizationRequired = UserAuthorizationRequired, Tags = Tags)
  output <- .chatbot$create_slack_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$create_slack_channel_configuration <- chatbot_create_slack_channel_configuration

#' Deletes a Amazon Chime webhook configuration for AWS Chatbot
#'
#' @description
#' Deletes a Amazon Chime webhook configuration for AWS Chatbot.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_chime_webhook_configuration/](https://www.paws-r-sdk.com/docs/chatbot_delete_chime_webhook_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the ChimeWebhookConfiguration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_chime_webhook_configuration
chatbot_delete_chime_webhook_configuration <- function(ChatConfigurationArn) {
  op <- new_operation(
    name = "DeleteChimeWebhookConfiguration",
    http_method = "POST",
    http_path = "/delete-chime-webhook-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_chime_webhook_configuration_input(ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$delete_chime_webhook_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_chime_webhook_configuration <- chatbot_delete_chime_webhook_configuration

#' Deletes a custom action
#'
#' @description
#' Deletes a custom action.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_custom_action/](https://www.paws-r-sdk.com/docs/chatbot_delete_custom_action/) for full documentation.
#'
#' @param CustomActionArn &#91;required&#93; The fully defined ARN of the custom action.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_custom_action
chatbot_delete_custom_action <- function(CustomActionArn) {
  op <- new_operation(
    name = "DeleteCustomAction",
    http_method = "POST",
    http_path = "/delete-custom-action",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_custom_action_input(CustomActionArn = CustomActionArn)
  output <- .chatbot$delete_custom_action_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_custom_action <- chatbot_delete_custom_action

#' Deletes a Microsoft Teams channel configuration for AWS Chatbot
#'
#' @description
#' Deletes a Microsoft Teams channel configuration for AWS Chatbot
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_channel_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration
#' associated with the user identity to delete.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_microsoft_teams_channel_configuration
chatbot_delete_microsoft_teams_channel_configuration <- function(ChatConfigurationArn) {
  op <- new_operation(
    name = "DeleteMicrosoftTeamsChannelConfiguration",
    http_method = "POST",
    http_path = "/delete-ms-teams-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_microsoft_teams_channel_configuration_input(ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$delete_microsoft_teams_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_microsoft_teams_channel_configuration <- chatbot_delete_microsoft_teams_channel_configuration

#' Deletes the Microsoft Teams team authorization allowing for channels to
#' be configured in that Microsoft Teams team
#'
#' @description
#' Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams team. Note that the Microsoft Teams team must have no channels configured to remove it.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_configured_team/](https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_configured_team/) for full documentation.
#'
#' @param TeamId &#91;required&#93; The ID of the Microsoft Teams team authorized with AWS Chatbot.
#' 
#' To get the team ID, you must perform the initial authorization flow with
#' Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
#' the team ID from the console. For more information, see [Step 1:
#' Configure a Microsoft Teams
#' client](https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup)
#' in the *AWS Chatbot Administrator Guide*.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_microsoft_teams_configured_team
chatbot_delete_microsoft_teams_configured_team <- function(TeamId) {
  op <- new_operation(
    name = "DeleteMicrosoftTeamsConfiguredTeam",
    http_method = "POST",
    http_path = "/delete-ms-teams-configured-teams",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_microsoft_teams_configured_team_input(TeamId = TeamId)
  output <- .chatbot$delete_microsoft_teams_configured_team_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_microsoft_teams_configured_team <- chatbot_delete_microsoft_teams_configured_team

#' Identifes a user level permission for a channel configuration
#'
#' @description
#' Identifes a user level permission for a channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_user_identity/](https://www.paws-r-sdk.com/docs/chatbot_delete_microsoft_teams_user_identity/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The ARN of the MicrosoftTeamsChannelConfiguration associated with the
#' user identity to delete.
#' @param UserId &#91;required&#93; The Microsoft Teams user ID.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_microsoft_teams_user_identity
chatbot_delete_microsoft_teams_user_identity <- function(ChatConfigurationArn, UserId) {
  op <- new_operation(
    name = "DeleteMicrosoftTeamsUserIdentity",
    http_method = "POST",
    http_path = "/delete-ms-teams-user-identity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_microsoft_teams_user_identity_input(ChatConfigurationArn = ChatConfigurationArn, UserId = UserId)
  output <- .chatbot$delete_microsoft_teams_user_identity_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_microsoft_teams_user_identity <- chatbot_delete_microsoft_teams_user_identity

#' Deletes a Slack channel configuration for AWS Chatbot
#'
#' @description
#' Deletes a Slack channel configuration for AWS Chatbot
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_delete_slack_channel_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the SlackChannelConfiguration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_slack_channel_configuration
chatbot_delete_slack_channel_configuration <- function(ChatConfigurationArn) {
  op <- new_operation(
    name = "DeleteSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/delete-slack-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_slack_channel_configuration_input(ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$delete_slack_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_slack_channel_configuration <- chatbot_delete_slack_channel_configuration

#' Deletes a user level permission for a Slack channel configuration
#'
#' @description
#' Deletes a user level permission for a Slack channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_slack_user_identity/](https://www.paws-r-sdk.com/docs/chatbot_delete_slack_user_identity/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The ARN of the SlackChannelConfiguration associated with the user
#' identity to delete.
#' @param SlackTeamId &#91;required&#93; The ID of the Slack workspace authorized with AWS Chatbot.
#' @param SlackUserId &#91;required&#93; The ID of the user in Slack
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_slack_user_identity
chatbot_delete_slack_user_identity <- function(ChatConfigurationArn, SlackTeamId, SlackUserId) {
  op <- new_operation(
    name = "DeleteSlackUserIdentity",
    http_method = "POST",
    http_path = "/delete-slack-user-identity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_slack_user_identity_input(ChatConfigurationArn = ChatConfigurationArn, SlackTeamId = SlackTeamId, SlackUserId = SlackUserId)
  output <- .chatbot$delete_slack_user_identity_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_slack_user_identity <- chatbot_delete_slack_user_identity

#' Deletes the Slack workspace authorization that allows channels to be
#' configured in that workspace
#'
#' @description
#' Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires all configured channels in the workspace to be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_delete_slack_workspace_authorization/](https://www.paws-r-sdk.com/docs/chatbot_delete_slack_workspace_authorization/) for full documentation.
#'
#' @param SlackTeamId &#91;required&#93; The ID of the Slack workspace authorized with AWS Chatbot.
#'
#' @keywords internal
#'
#' @rdname chatbot_delete_slack_workspace_authorization
chatbot_delete_slack_workspace_authorization <- function(SlackTeamId) {
  op <- new_operation(
    name = "DeleteSlackWorkspaceAuthorization",
    http_method = "POST",
    http_path = "/delete-slack-workspace-authorization",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$delete_slack_workspace_authorization_input(SlackTeamId = SlackTeamId)
  output <- .chatbot$delete_slack_workspace_authorization_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$delete_slack_workspace_authorization <- chatbot_delete_slack_workspace_authorization

#' Lists Amazon Chime webhook configurations optionally filtered by
#' ChatConfigurationArn
#'
#' @description
#' Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_describe_chime_webhook_configurations/](https://www.paws-r-sdk.com/docs/chatbot_describe_chime_webhook_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#' @param ChatConfigurationArn An optional Amazon Resource Name (ARN) of a ChimeWebhookConfiguration to
#' describe.
#'
#' @keywords internal
#'
#' @rdname chatbot_describe_chime_webhook_configurations
chatbot_describe_chime_webhook_configurations <- function(MaxResults = NULL, NextToken = NULL, ChatConfigurationArn = NULL) {
  op <- new_operation(
    name = "DescribeChimeWebhookConfigurations",
    http_method = "POST",
    http_path = "/describe-chime-webhook-configurations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "WebhookConfigurations"),
    stream_api = FALSE
  )
  input <- .chatbot$describe_chime_webhook_configurations_input(MaxResults = MaxResults, NextToken = NextToken, ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$describe_chime_webhook_configurations_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$describe_chime_webhook_configurations <- chatbot_describe_chime_webhook_configurations

#' Lists Slack channel configurations optionally filtered by
#' ChatConfigurationArn
#'
#' @description
#' Lists Slack channel configurations optionally filtered by ChatConfigurationArn
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_describe_slack_channel_configurations/](https://www.paws-r-sdk.com/docs/chatbot_describe_slack_channel_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#' @param ChatConfigurationArn An optional Amazon Resource Name (ARN) of a SlackChannelConfiguration to
#' describe.
#'
#' @keywords internal
#'
#' @rdname chatbot_describe_slack_channel_configurations
chatbot_describe_slack_channel_configurations <- function(MaxResults = NULL, NextToken = NULL, ChatConfigurationArn = NULL) {
  op <- new_operation(
    name = "DescribeSlackChannelConfigurations",
    http_method = "POST",
    http_path = "/describe-slack-channel-configurations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SlackChannelConfigurations"),
    stream_api = FALSE
  )
  input <- .chatbot$describe_slack_channel_configurations_input(MaxResults = MaxResults, NextToken = NextToken, ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$describe_slack_channel_configurations_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$describe_slack_channel_configurations <- chatbot_describe_slack_channel_configurations

#' Lists all Slack user identities with a mapped role
#'
#' @description
#' Lists all Slack user identities with a mapped role.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_describe_slack_user_identities/](https://www.paws-r-sdk.com/docs/chatbot_describe_slack_user_identities/) for full documentation.
#'
#' @param ChatConfigurationArn The Amazon Resource Name (ARN) of the SlackChannelConfiguration
#' associated with the user identities to describe.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#'
#' @keywords internal
#'
#' @rdname chatbot_describe_slack_user_identities
chatbot_describe_slack_user_identities <- function(ChatConfigurationArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSlackUserIdentities",
    http_method = "POST",
    http_path = "/describe-slack-user-identities",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SlackUserIdentities"),
    stream_api = FALSE
  )
  input <- .chatbot$describe_slack_user_identities_input(ChatConfigurationArn = ChatConfigurationArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .chatbot$describe_slack_user_identities_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$describe_slack_user_identities <- chatbot_describe_slack_user_identities

#' List all authorized Slack workspaces connected to the AWS Account
#' onboarded with AWS Chatbot
#'
#' @description
#' List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_describe_slack_workspaces/](https://www.paws-r-sdk.com/docs/chatbot_describe_slack_workspaces/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#'
#' @keywords internal
#'
#' @rdname chatbot_describe_slack_workspaces
chatbot_describe_slack_workspaces <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSlackWorkspaces",
    http_method = "POST",
    http_path = "/describe-slack-workspaces",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SlackWorkspaces"),
    stream_api = FALSE
  )
  input <- .chatbot$describe_slack_workspaces_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .chatbot$describe_slack_workspaces_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$describe_slack_workspaces <- chatbot_describe_slack_workspaces

#' Unlink a resource, for example a custom action, from a channel
#' configuration
#'
#' @description
#' Unlink a resource, for example a custom action, from a channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_disassociate_from_configuration/](https://www.paws-r-sdk.com/docs/chatbot_disassociate_from_configuration/) for full documentation.
#'
#' @param Resource &#91;required&#93; The resource (for example, a custom action) Amazon Resource Name (ARN)
#' to unlink.
#' @param ChatConfiguration &#91;required&#93; The channel configuration the resource is being disassociated from.
#'
#' @keywords internal
#'
#' @rdname chatbot_disassociate_from_configuration
chatbot_disassociate_from_configuration <- function(Resource, ChatConfiguration) {
  op <- new_operation(
    name = "DisassociateFromConfiguration",
    http_method = "POST",
    http_path = "/disassociate-from-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$disassociate_from_configuration_input(Resource = Resource, ChatConfiguration = ChatConfiguration)
  output <- .chatbot$disassociate_from_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$disassociate_from_configuration <- chatbot_disassociate_from_configuration

#' Returns AWS Chatbot account preferences
#'
#' @description
#' Returns AWS Chatbot account preferences.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_get_account_preferences/](https://www.paws-r-sdk.com/docs/chatbot_get_account_preferences/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname chatbot_get_account_preferences
chatbot_get_account_preferences <- function() {
  op <- new_operation(
    name = "GetAccountPreferences",
    http_method = "POST",
    http_path = "/get-account-preferences",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$get_account_preferences_input()
  output <- .chatbot$get_account_preferences_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$get_account_preferences <- chatbot_get_account_preferences

#' Returns a custom action
#'
#' @description
#' Returns a custom action.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_get_custom_action/](https://www.paws-r-sdk.com/docs/chatbot_get_custom_action/) for full documentation.
#'
#' @param CustomActionArn &#91;required&#93; Returns the fully defined Amazon Resource Name (ARN) of the custom
#' action.
#'
#' @keywords internal
#'
#' @rdname chatbot_get_custom_action
chatbot_get_custom_action <- function(CustomActionArn) {
  op <- new_operation(
    name = "GetCustomAction",
    http_method = "POST",
    http_path = "/get-custom-action",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$get_custom_action_input(CustomActionArn = CustomActionArn)
  output <- .chatbot$get_custom_action_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$get_custom_action <- chatbot_get_custom_action

#' Returns a Microsoft Teams channel configuration in an AWS account
#'
#' @description
#' Returns a Microsoft Teams channel configuration in an AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_get_microsoft_teams_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_get_microsoft_teams_channel_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration
#' to retrieve.
#'
#' @keywords internal
#'
#' @rdname chatbot_get_microsoft_teams_channel_configuration
chatbot_get_microsoft_teams_channel_configuration <- function(ChatConfigurationArn) {
  op <- new_operation(
    name = "GetMicrosoftTeamsChannelConfiguration",
    http_method = "POST",
    http_path = "/get-ms-teams-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$get_microsoft_teams_channel_configuration_input(ChatConfigurationArn = ChatConfigurationArn)
  output <- .chatbot$get_microsoft_teams_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$get_microsoft_teams_channel_configuration <- chatbot_get_microsoft_teams_channel_configuration

#' Lists resources associated with a channel configuration
#'
#' @description
#' Lists resources associated with a channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_associations/](https://www.paws-r-sdk.com/docs/chatbot_list_associations/) for full documentation.
#'
#' @param ChatConfiguration &#91;required&#93; The channel configuration to list associations for.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_associations
chatbot_list_associations <- function(ChatConfiguration, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociations",
    http_method = "POST",
    http_path = "/list-associations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Associations"),
    stream_api = FALSE
  )
  input <- .chatbot$list_associations_input(ChatConfiguration = ChatConfiguration, MaxResults = MaxResults, NextToken = NextToken)
  output <- .chatbot$list_associations_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_associations <- chatbot_list_associations

#' Lists custom actions defined in this account
#'
#' @description
#' Lists custom actions defined in this account.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_custom_actions/](https://www.paws-r-sdk.com/docs/chatbot_list_custom_actions/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_custom_actions
chatbot_list_custom_actions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomActions",
    http_method = "POST",
    http_path = "/list-custom-actions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "CustomActions"),
    stream_api = FALSE
  )
  input <- .chatbot$list_custom_actions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .chatbot$list_custom_actions_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_custom_actions <- chatbot_list_custom_actions

#' Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS
#' account
#'
#' @description
#' Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_channel_configurations/](https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_channel_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#' @param TeamId The ID of the Microsoft Teams authorized with AWS Chatbot.
#' 
#' To get the team ID, you must perform the initial authorization flow with
#' Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
#' the team ID from the console. For more information, see [Step 1:
#' Configure a Microsoft Teams
#' client](https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup)
#' in the *AWS Chatbot Administrator Guide*.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_microsoft_teams_channel_configurations
chatbot_list_microsoft_teams_channel_configurations <- function(MaxResults = NULL, NextToken = NULL, TeamId = NULL) {
  op <- new_operation(
    name = "ListMicrosoftTeamsChannelConfigurations",
    http_method = "POST",
    http_path = "/list-ms-teams-channel-configurations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TeamChannelConfigurations"),
    stream_api = FALSE
  )
  input <- .chatbot$list_microsoft_teams_channel_configurations_input(MaxResults = MaxResults, NextToken = NextToken, TeamId = TeamId)
  output <- .chatbot$list_microsoft_teams_channel_configurations_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_microsoft_teams_channel_configurations <- chatbot_list_microsoft_teams_channel_configurations

#' Lists all authorized Microsoft Teams for an AWS Account
#'
#' @description
#' Lists all authorized Microsoft Teams for an AWS Account
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_configured_teams/](https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_configured_teams/) for full documentation.
#'
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_microsoft_teams_configured_teams
chatbot_list_microsoft_teams_configured_teams <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMicrosoftTeamsConfiguredTeams",
    http_method = "POST",
    http_path = "/list-ms-teams-configured-teams",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ConfiguredTeams"),
    stream_api = FALSE
  )
  input <- .chatbot$list_microsoft_teams_configured_teams_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .chatbot$list_microsoft_teams_configured_teams_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_microsoft_teams_configured_teams <- chatbot_list_microsoft_teams_configured_teams

#' A list all Microsoft Teams user identities with a mapped role
#'
#' @description
#' A list all Microsoft Teams user identities with a mapped role.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_user_identities/](https://www.paws-r-sdk.com/docs/chatbot_list_microsoft_teams_user_identities/) for full documentation.
#'
#' @param ChatConfigurationArn The Amazon Resource Name (ARN) of the MicrosoftTeamsChannelConfiguration
#' associated with the user identities to list.
#' @param NextToken An optional token returned from a prior request. Use this token for
#' pagination of results from this action. If this parameter is specified,
#' the response includes only results beyond the token, up to the value
#' specified by MaxResults.
#' @param MaxResults The maximum number of results to include in the response. If more
#' results exist than the specified MaxResults value, a token is included
#' in the response so that the remaining results can be retrieved.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_microsoft_teams_user_identities
chatbot_list_microsoft_teams_user_identities <- function(ChatConfigurationArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMicrosoftTeamsUserIdentities",
    http_method = "POST",
    http_path = "/list-ms-teams-user-identities",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "TeamsUserIdentities"),
    stream_api = FALSE
  )
  input <- .chatbot$list_microsoft_teams_user_identities_input(ChatConfigurationArn = ChatConfigurationArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .chatbot$list_microsoft_teams_user_identities_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_microsoft_teams_user_identities <- chatbot_list_microsoft_teams_user_identities

#' Lists all of the tags associated with the Amazon Resource Name (ARN)
#' that you specify
#'
#' @description
#' Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/chatbot_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the resource to list tags for.
#'
#' @keywords internal
#'
#' @rdname chatbot_list_tags_for_resource
chatbot_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/list-tags-for-resource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .chatbot$list_tags_for_resource_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$list_tags_for_resource <- chatbot_list_tags_for_resource

#' Attaches a key-value pair to a resource, as identified by its Amazon
#' Resource Name (ARN)
#'
#' @description
#' Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_tag_resource/](https://www.paws-r-sdk.com/docs/chatbot_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the configuration.
#' @param Tags &#91;required&#93; A list of tags to apply to the configuration.
#'
#' @keywords internal
#'
#' @rdname chatbot_tag_resource
chatbot_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tag-resource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .chatbot$tag_resource_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$tag_resource <- chatbot_tag_resource

#' Detaches a key-value pair from a resource, as identified by its Amazon
#' Resource Name (ARN)
#'
#' @description
#' Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_untag_resource/](https://www.paws-r-sdk.com/docs/chatbot_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The value of the resource that will have the tag removed. An Amazon
#' Resource Name (ARN) is an identifier for a specific AWS resource, such
#' as a server, user, or role.
#' @param TagKeys &#91;required&#93; TagKeys are key-value pairs assigned to ARNs that can be used to group
#' and search for resources by type. This metadata can be attached to
#' resources for any purpose.
#'
#' @keywords internal
#'
#' @rdname chatbot_untag_resource
chatbot_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untag-resource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .chatbot$untag_resource_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$untag_resource <- chatbot_untag_resource

#' Updates AWS Chatbot account preferences
#'
#' @description
#' Updates AWS Chatbot account preferences.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_update_account_preferences/](https://www.paws-r-sdk.com/docs/chatbot_update_account_preferences/) for full documentation.
#'
#' @param UserAuthorizationRequired Enables use of a user role requirement in your chat configuration.
#' @param TrainingDataCollectionEnabled Turns on training data collection.
#' 
#' This helps improve the AWS Chatbot experience by allowing AWS Chatbot to
#' store and use your customer information, such as AWS Chatbot
#' configurations, notifications, user inputs, AWS Chatbot generated
#' responses, and interaction data. This data helps us to continuously
#' improve and develop Artificial Intelligence (AI) technologies. Your data
#' is not shared with any third parties and is protected using
#' sophisticated controls to prevent unauthorized access and misuse. AWS
#' Chatbot does not store or use interactions in chat channels with Amazon
#' Q for training AI technologies for AWS Chatbot.
#'
#' @keywords internal
#'
#' @rdname chatbot_update_account_preferences
chatbot_update_account_preferences <- function(UserAuthorizationRequired = NULL, TrainingDataCollectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateAccountPreferences",
    http_method = "POST",
    http_path = "/update-account-preferences",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$update_account_preferences_input(UserAuthorizationRequired = UserAuthorizationRequired, TrainingDataCollectionEnabled = TrainingDataCollectionEnabled)
  output <- .chatbot$update_account_preferences_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$update_account_preferences <- chatbot_update_account_preferences

#' Updates a Amazon Chime webhook configuration
#'
#' @description
#' Updates a Amazon Chime webhook configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_update_chime_webhook_configuration/](https://www.paws-r-sdk.com/docs/chatbot_update_chime_webhook_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the ChimeWebhookConfiguration to
#' update.
#' @param WebhookDescription A description of the webhook. We recommend using the convention
#' `RoomName/WebhookName`.
#' 
#' For more information, see [Tutorial: Get started with Amazon
#' Chime](https://docs.aws.amazon.com/chatbot/latest/adminguide/chime-setup.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param WebhookUrl The URL for the Amazon Chime webhook.
#' @param SnsTopicArns The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
#' @param IamRoleArn A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#'
#' @keywords internal
#'
#' @rdname chatbot_update_chime_webhook_configuration
chatbot_update_chime_webhook_configuration <- function(ChatConfigurationArn, WebhookDescription = NULL, WebhookUrl = NULL, SnsTopicArns = NULL, IamRoleArn = NULL, LoggingLevel = NULL) {
  op <- new_operation(
    name = "UpdateChimeWebhookConfiguration",
    http_method = "POST",
    http_path = "/update-chime-webhook-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$update_chime_webhook_configuration_input(ChatConfigurationArn = ChatConfigurationArn, WebhookDescription = WebhookDescription, WebhookUrl = WebhookUrl, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, LoggingLevel = LoggingLevel)
  output <- .chatbot$update_chime_webhook_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$update_chime_webhook_configuration <- chatbot_update_chime_webhook_configuration

#' Updates a custom action
#'
#' @description
#' Updates a custom action.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_update_custom_action/](https://www.paws-r-sdk.com/docs/chatbot_update_custom_action/) for full documentation.
#'
#' @param CustomActionArn &#91;required&#93; The fully defined Amazon Resource Name (ARN) of the custom action.
#' @param Definition &#91;required&#93; The definition of the command to run when invoked as an alias or as an
#' action button.
#' @param AliasName The name used to invoke this action in the chat channel. For example,
#' `@@aws run my-alias`.
#' @param Attachments Defines when this custom action button should be attached to a
#' notification.
#'
#' @keywords internal
#'
#' @rdname chatbot_update_custom_action
chatbot_update_custom_action <- function(CustomActionArn, Definition, AliasName = NULL, Attachments = NULL) {
  op <- new_operation(
    name = "UpdateCustomAction",
    http_method = "POST",
    http_path = "/update-custom-action",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$update_custom_action_input(CustomActionArn = CustomActionArn, Definition = Definition, AliasName = AliasName, Attachments = Attachments)
  output <- .chatbot$update_custom_action_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$update_custom_action <- chatbot_update_custom_action

#' Updates an Microsoft Teams channel configuration
#'
#' @description
#' Updates an Microsoft Teams channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_update_microsoft_teams_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_update_microsoft_teams_channel_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the TeamsChannelConfiguration to
#' update.
#' @param ChannelId &#91;required&#93; The ID of the Microsoft Teams channel.
#' @param ChannelName The name of the Microsoft Teams channel.
#' @param SnsTopicArns The Amazon Resource Names (ARNs) of the SNS topics that deliver
#' notifications to AWS Chatbot.
#' @param IamRoleArn A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#' @param GuardrailPolicyArns The list of IAM policy ARNs that are applied as channel guardrails. The
#' AWS managed `AdministratorAccess` policy is applied by default if this
#' is not set.
#' @param UserAuthorizationRequired Enables use of a user role requirement in your chat configuration.
#'
#' @keywords internal
#'
#' @rdname chatbot_update_microsoft_teams_channel_configuration
chatbot_update_microsoft_teams_channel_configuration <- function(ChatConfigurationArn, ChannelId, ChannelName = NULL, SnsTopicArns = NULL, IamRoleArn = NULL, LoggingLevel = NULL, GuardrailPolicyArns = NULL, UserAuthorizationRequired = NULL) {
  op <- new_operation(
    name = "UpdateMicrosoftTeamsChannelConfiguration",
    http_method = "POST",
    http_path = "/update-ms-teams-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$update_microsoft_teams_channel_configuration_input(ChatConfigurationArn = ChatConfigurationArn, ChannelId = ChannelId, ChannelName = ChannelName, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, LoggingLevel = LoggingLevel, GuardrailPolicyArns = GuardrailPolicyArns, UserAuthorizationRequired = UserAuthorizationRequired)
  output <- .chatbot$update_microsoft_teams_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$update_microsoft_teams_channel_configuration <- chatbot_update_microsoft_teams_channel_configuration

#' Updates a Slack channel configuration
#'
#' @description
#' Updates a Slack channel configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/chatbot_update_slack_channel_configuration/](https://www.paws-r-sdk.com/docs/chatbot_update_slack_channel_configuration/) for full documentation.
#'
#' @param ChatConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the SlackChannelConfiguration to
#' update.
#' @param SlackChannelId &#91;required&#93; The ID of the Slack channel.
#' 
#' To get this ID, open Slack, right click on the channel name in the left
#' pane, then choose Copy Link. The channel ID is the 9-character string at
#' the end of the URL. For example, ABCBBLZZZ.
#' @param SlackChannelName The name of the Slack channel.
#' @param SnsTopicArns The Amazon Resource Names (ARNs) of the SNS topics that deliver
#' notifications to AWS Chatbot.
#' @param IamRoleArn A user-defined role that AWS Chatbot assumes. This is not the
#' service-linked role.
#' 
#' For more information, see [IAM policies for AWS
#' Chatbot](https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html)
#' in the *AWS Chatbot Administrator Guide*.
#' @param LoggingLevel Logging levels include `ERROR`, `INFO`, or `NONE`.
#' @param GuardrailPolicyArns The list of IAM policy ARNs that are applied as channel guardrails. The
#' AWS managed `AdministratorAccess` policy is applied by default if this
#' is not set.
#' @param UserAuthorizationRequired Enables use of a user role requirement in your chat configuration.
#'
#' @keywords internal
#'
#' @rdname chatbot_update_slack_channel_configuration
chatbot_update_slack_channel_configuration <- function(ChatConfigurationArn, SlackChannelId, SlackChannelName = NULL, SnsTopicArns = NULL, IamRoleArn = NULL, LoggingLevel = NULL, GuardrailPolicyArns = NULL, UserAuthorizationRequired = NULL) {
  op <- new_operation(
    name = "UpdateSlackChannelConfiguration",
    http_method = "POST",
    http_path = "/update-slack-channel-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .chatbot$update_slack_channel_configuration_input(ChatConfigurationArn = ChatConfigurationArn, SlackChannelId = SlackChannelId, SlackChannelName = SlackChannelName, SnsTopicArns = SnsTopicArns, IamRoleArn = IamRoleArn, LoggingLevel = LoggingLevel, GuardrailPolicyArns = GuardrailPolicyArns, UserAuthorizationRequired = UserAuthorizationRequired)
  output <- .chatbot$update_slack_channel_configuration_output()
  config <- get_config()
  svc <- .chatbot$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.chatbot$operations$update_slack_channel_configuration <- chatbot_update_slack_channel_configuration
