# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Lex Model Building Service
#'
#' @description
#' Amazon Lex Build-Time Actions
#' 
#' Amazon Lex is an AWS service for building conversational voice and text
#' interfaces. Use these actions to create, update, and delete
#' conversational bots for new and existing client applications.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- lexmodelbuildingservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- lexmodelbuildingservice()
#' # This example shows how to get configuration information for a bot.
#' svc$get_bot(
#'   name = "DocOrderPizza",
#'   versionOrAlias = "$LATEST"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=lexmodelbuildingservice_create_bot_version]{create_bot_version} \tab Creates a new version of the bot based on the $LATEST version\cr
#'  \link[=lexmodelbuildingservice_create_intent_version]{create_intent_version} \tab Creates a new version of an intent based on the $LATEST version of the intent\cr
#'  \link[=lexmodelbuildingservice_create_slot_type_version]{create_slot_type_version} \tab Creates a new version of a slot type based on the $LATEST version of the specified slot type\cr
#'  \link[=lexmodelbuildingservice_delete_bot]{delete_bot} \tab Deletes all versions of the bot, including the $LATEST version\cr
#'  \link[=lexmodelbuildingservice_delete_bot_alias]{delete_bot_alias} \tab Deletes an alias for the specified bot\cr
#'  \link[=lexmodelbuildingservice_delete_bot_channel_association]{delete_bot_channel_association} \tab Deletes the association between an Amazon Lex bot and a messaging platform\cr
#'  \link[=lexmodelbuildingservice_delete_bot_version]{delete_bot_version} \tab Deletes a specific version of a bot\cr
#'  \link[=lexmodelbuildingservice_delete_intent]{delete_intent} \tab Deletes all versions of the intent, including the $LATEST version\cr
#'  \link[=lexmodelbuildingservice_delete_intent_version]{delete_intent_version} \tab Deletes a specific version of an intent\cr
#'  \link[=lexmodelbuildingservice_delete_slot_type]{delete_slot_type} \tab Deletes all versions of the slot type, including the $LATEST version\cr
#'  \link[=lexmodelbuildingservice_delete_slot_type_version]{delete_slot_type_version} \tab Deletes a specific version of a slot type\cr
#'  \link[=lexmodelbuildingservice_delete_utterances]{delete_utterances} \tab Deletes stored utterances\cr
#'  \link[=lexmodelbuildingservice_get_bot]{get_bot} \tab Returns metadata information for a specific bot\cr
#'  \link[=lexmodelbuildingservice_get_bot_alias]{get_bot_alias} \tab Returns information about an Amazon Lex bot alias\cr
#'  \link[=lexmodelbuildingservice_get_bot_aliases]{get_bot_aliases} \tab Returns a list of aliases for a specified Amazon Lex bot\cr
#'  \link[=lexmodelbuildingservice_get_bot_channel_association]{get_bot_channel_association} \tab Returns information about the association between an Amazon Lex bot and a messaging platform\cr
#'  \link[=lexmodelbuildingservice_get_bot_channel_associations]{get_bot_channel_associations} \tab Returns a list of all of the channels associated with the specified bot\cr
#'  \link[=lexmodelbuildingservice_get_bots]{get_bots} \tab Returns bot information as follows:\cr
#'  \link[=lexmodelbuildingservice_get_bot_versions]{get_bot_versions} \tab Gets information about all of the versions of a bot\cr
#'  \link[=lexmodelbuildingservice_get_builtin_intent]{get_builtin_intent} \tab Returns information about a built-in intent\cr
#'  \link[=lexmodelbuildingservice_get_builtin_intents]{get_builtin_intents} \tab Gets a list of built-in intents that meet the specified criteria\cr
#'  \link[=lexmodelbuildingservice_get_builtin_slot_types]{get_builtin_slot_types} \tab Gets a list of built-in slot types that meet the specified criteria\cr
#'  \link[=lexmodelbuildingservice_get_export]{get_export} \tab Exports the contents of a Amazon Lex resource in a specified format\cr
#'  \link[=lexmodelbuildingservice_get_import]{get_import} \tab Gets information about an import job started with the StartImport operation\cr
#'  \link[=lexmodelbuildingservice_get_intent]{get_intent} \tab Returns information about an intent\cr
#'  \link[=lexmodelbuildingservice_get_intents]{get_intents} \tab Returns intent information as follows:\cr
#'  \link[=lexmodelbuildingservice_get_intent_versions]{get_intent_versions} \tab Gets information about all of the versions of an intent\cr
#'  \link[=lexmodelbuildingservice_get_migration]{get_migration} \tab Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot\cr
#'  \link[=lexmodelbuildingservice_get_migrations]{get_migrations} \tab Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2\cr
#'  \link[=lexmodelbuildingservice_get_slot_type]{get_slot_type} \tab Returns information about a specific version of a slot type\cr
#'  \link[=lexmodelbuildingservice_get_slot_types]{get_slot_types} \tab Returns slot type information as follows:\cr
#'  \link[=lexmodelbuildingservice_get_slot_type_versions]{get_slot_type_versions} \tab Gets information about all versions of a slot type\cr
#'  \link[=lexmodelbuildingservice_get_utterances_view]{get_utterances_view} \tab Use the GetUtterancesView operation to get information about the utterances that your users have made to your bot\cr
#'  \link[=lexmodelbuildingservice_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags associated with the specified resource\cr
#'  \link[=lexmodelbuildingservice_put_bot]{put_bot} \tab Creates an Amazon Lex conversational bot or replaces an existing bot\cr
#'  \link[=lexmodelbuildingservice_put_bot_alias]{put_bot_alias} \tab Creates an alias for the specified version of the bot or replaces an alias for the specified bot\cr
#'  \link[=lexmodelbuildingservice_put_intent]{put_intent} \tab Creates an intent or replaces an existing intent\cr
#'  \link[=lexmodelbuildingservice_put_slot_type]{put_slot_type} \tab Creates a custom slot type or replaces an existing custom slot type\cr
#'  \link[=lexmodelbuildingservice_start_import]{start_import} \tab Starts a job to import a resource to Amazon Lex\cr
#'  \link[=lexmodelbuildingservice_start_migration]{start_migration} \tab Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2\cr
#'  \link[=lexmodelbuildingservice_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource\cr
#'  \link[=lexmodelbuildingservice_untag_resource]{untag_resource} \tab Removes tags from a bot, bot alias or bot channel
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname lexmodelbuildingservice
#' @export
lexmodelbuildingservice <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .lexmodelbuildingservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.lexmodelbuildingservice <- list()

.lexmodelbuildingservice$operations <- list()

.lexmodelbuildingservice$metadata <- list(
  service_name = "models.lex",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "models.lex.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Lex Model Building Service",
  api_version = "2017-04-19",
  signing_name = "lex",
  json_version = "1.1",
  target_prefix = ""
)

.lexmodelbuildingservice$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.lexmodelbuildingservice$metadata, handlers, config, op)
}
