% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_get_knowledge_base_documents}
\alias{bedrockagent_get_knowledge_base_documents}
\title{Retrieves specific documents from a data source that is connected to a
knowledge base}
\usage{
bedrockagent_get_knowledge_base_documents(
  dataSourceId,
  documentIdentifiers,
  knowledgeBaseId
)
}
\arguments{
\item{dataSourceId}{[required] The unique identifier of the data source that contains the documents.}

\item{documentIdentifiers}{[required] A list of objects, each of which contains information to identify a
document for which to retrieve information.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base that is connected to the
data source.}
}
\description{
Retrieves specific documents from a data source that is connected to a knowledge base. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/kb-direct-ingestion.html}{Ingest changes directly into a knowledge base} in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_get_knowledge_base_documents/} for full documentation.
}
\keyword{internal}
