% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_utterance_metrics}
\alias{lexmodelsv2_list_utterance_metrics}
\title{To use this API operation, your IAM role must have permissions to
perform the ListAggregatedUtterances operation, which provides access to
utterance-related analytics}
\usage{
lexmodelsv2_list_utterance_metrics(
  botId,
  startDateTime,
  endDateTime,
  metrics,
  binBy = NULL,
  groupBy = NULL,
  attributes = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{botId}{[required] The identifier for the bot for which you want to retrieve utterance
metrics.}

\item{startDateTime}{[required] The date and time that marks the beginning of the range of time for
which you want to see utterance metrics.}

\item{endDateTime}{[required] The date and time that marks the end of the range of time for which you
want to see utterance metrics.}

\item{metrics}{[required] A list of objects, each of which contains a metric you want to list, the
statistic for the metric you want to return, and the method by which to
organize the results.}

\item{binBy}{A list of objects, each of which contains specifications for organizing
the results by time.}

\item{groupBy}{A list of objects, each of which specifies how to group the results. You
can group by the following criteria:
\itemize{
\item \code{UtteranceText} – The transcription of the utterance.
\item \code{UtteranceState} – The state of the utterance. The possible states
are detailed in Key definitions in the user guide.
}}

\item{attributes}{A list containing attributes related to the utterance that you want the
response to return. The following attributes are possible:
\itemize{
\item \code{LastUsedIntent} – The last used intent at the time of the
utterance.
}}

\item{filters}{A list of objects, each of which describes a condition by which you want
to filter the results.}

\item{maxResults}{The maximum number of results to return in each page of results. If
there are fewer results than the maximum page size, only the actual
number of results are returned.}

\item{nextToken}{If the response from the ListUtteranceMetrics operation contains more
results than specified in the maxResults parameter, a token is returned
in the response.

Use the returned token in the nextToken parameter of a
ListUtteranceMetrics request to return the next page of results. For a
complete set of results, call the ListUtteranceMetrics operation until
the nextToken returned in the response is null.}
}
\description{
To use this API operation, your IAM role must have permissions to perform the \code{\link[=lexmodelsv2_list_aggregated_utterances]{list_aggregated_utterances}} operation, which provides access to utterance-related analytics. See \href{https://docs.aws.amazon.com/lexv2/latest/dg/}{Viewing utterance statistics} for the IAM policy to apply to the IAM role.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_utterance_metrics/} for full documentation.
}
\keyword{internal}
